; The CMD file.
;
; Two parts: 1. Command definition and  2. State entry
; (state entry is after the commands def section)
;
; 1. Command definition
; ---------------------
; Note: The commands are CASE-SENSITIVE, and so are the command names.
; The eight directions are:
;   B, DB, D, DF, F, UF, U, UB     (all CAPS)
;   corresponding to back, down-back, down, downforward, etc.
; The six buttons are:
;   a, b, c, x, y, z               (all lower case)
;   In default key config, abc are are the bottom, and xyz are on the
;   top row. For 2 button characters, we recommend you use a and b.
;   For 6 button characters, use abc for kicks and xyz for punches.
;
; Each [Command] section defines a command that you can use for
; state entry, as well as in the CNS file.
; The command section should look like:
;
;   [Command]
;   name = some_name
;   command = the_command
;   time = time (optional)
;   buffer.time = time (optional)
;
; - some_name
;   A name to give that command. You'll use this name to refer to
;   that command in the state entry, as well as the CNS. It is case-
;   sensitive (QCB_a is NOT the same as Qcb_a or QCB_A).
;
; - command
;   list of buttons or directions, separated by commas. Each of these
;   buttons or directions is referred to as a "symbol".
;   Directions and buttons can be preceded by special characters:
;   slash (/) - means the key must be held down
;          egs. command = /D       ;hold the down direction
;               command = /DB, a   ;hold down-back while you press a
;   tilde (~) - to detect key releases
;          egs. command = ~a       ;release the a button
;               command = ~D, F, a ;release down, press fwd, then a
;          If you want to detect "charge moves", you can specify
;          the time the key must be held down for (in game-ticks)
;          egs. command = ~30a     ;hold a for at least 30 ticks, then release
;   dollar ($) - Direction-only: detect as 4-way
;          egs. command = $D       ;will detect if D, DB or DF is held
;               command = $B       ;will detect if B, DB or UB is held
;   plus (+) - Buttons only: simultaneous press
;          egs. command = a+b      ;press a and b at the same time
;               command = x+y+z    ;press x, y and z at the same time
;   greater-than (>) - means there must be no other keys pressed or released
;                      between the previous and the current symbol.
;          egs. command = a, >~a   ;press a and release it without having hit
;                                  ;or released any other keys in between
;   You can combine the symbols:
;     eg. command = ~30$D, a+b     ;hold D, DB or DF for 30 ticks, release,
;                                  ;then press a and b together
;
;   Note: Successive direction symbols are always expanded in a manner similar
;         to this example:
;           command = F, F
;         is expanded when MUGEN reads it, to become equivalent to:
;           command = F, >~F, >F
;
;   It is recommended that for most "motion" commads, eg. quarter-circle-fwd,
;   you start off with a "release direction". This makes the command easier
;   to do.
;
; - time (optional)
;   Time allowed to do the command, given in game-ticks. The default
;   value for this is set in the [Defaults] section below. A typical
;   value is 15.
;
; - buffer.time (optional)
;   Time that the command will be buffered for. If the command is done
;   successfully, then it will be valid for this time. The simplest
;   case is to set this to 1. That means that the command is valid
;   only in the same tick it is performed. With a higher value, such
;   as 3 or 4, you can get a "looser" feel to the command. The result
;   is that combos can become easier to do because you can perform
;   the command early. Attacks just as you regain control (eg. from
;   getting up) also become easier to do. The side effect of this is
;   that the command is continuously asserted, so it will seem as if
;   you had performed the move rapidly in succession during the valid
;   time. To understand this, try setting buffer.time to 30 and hit
;   a fast attack, such as KFM's light punch.
;   The default value for this is set in the [Defaults] section below. 
;   This parameter does not affect hold-only commands (eg. /F). It
;   will be assumed to be 1 for those commands.
;
; If you have two or more commands with the same name, all of them will
; work. You can use it to allow multiple motions for the same move.
;
; Some common commands examples are given below.
;
; [Command] ;Quarter circle forward + x
; name = "QCF_x"
; command = ~D, DF, F, x
;
; [Command] ;Half circle back + a
; name = "HCB_a"
; command = ~F, DF, D, DB, B, a
;
; [Command] ;Two quarter circles forward + y
; name = "2QCF_y"
; command = ~D, DF, F, D, DF, F, y
;
; [Command] ;Tap b rapidly
; name = "5b"
; command = b, b, b, b, b
; time = 30
;
; [Command] ;Charge back, then forward + z
; name = "charge_B_F_z"
; command = ~60$B, F, z
; time = 10
;
; [Command] ;Charge down, then up + c
; name = "charge_D_U_c"
; command = ~60$D, U, c
; time = 10

;---------------------------------------------------------------------------
;Artificial Intelligence
;---------------------------------------------------------------------------

;-|-AI-|--------------------------------------------------------------------
[Command]
name = "AI_1"
command = a, x, F, D, a, a, D
time = 1

[Command]
name = "AI_2"
command = a, a, a, a, a, a, b
time = 1

[Command]
name = "AI_3"
command = a, a, b, D, F, b, x
time = 1

[Command]
name = "AI_4"
command = y, a, F, b, B, y, a
time = 1

[Command]
name = "AI_5"
command = a, b, x, y, y, b, b
time = 1

[Command]
name = "AI_6"
command = b, y, y, F, b, B, B
time = 1

[Command]
name = "AI_7"
command = a, y, F, a, x, a, F, b
time = 1

[Command]
name = "AI_8"
command = a, a, b, y, x, B, x
time = 1

[Command]
name = "AI_9"
command = x, x, a, F, F, b, D
time = 1

[Command]
name = "AI_10"
command = x, x, a, F, y, a, a, F
time = 1

[Command]
name = "AI_11"
command = a, b, a, x, a, y, a
time = 1

[Command]
name = "AI_12"
command = b, y, a, F, y, a, x
time = 1

[Command]
name = "AI_13"
command = x, a, y, y, x, B, B
time = 1

[Command]
name = "AI_14"
command = a, F, F, x, B, F, x
time = 1

[Command]
name = "AI_15"
command = y, x, b, b, a, x, y
time = 1

[Command]
name = "AI16"
command = s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s
time = 0
[Command]
name = "AI17"
command = a,B,c,x,y,z,s,B,D,F,U,a,b,c,x,y,z,s,s
time = 0
[Command]
name = "AI18"
command = a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a
time = 0
[Command]
name = "AI19"
command = b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b
time = 0
[Command]
name = "AI20"
command = c,c,c,c,c,c,c,c,c,c,c,c,c,c,c,c,c,c,c
time = 0
[Command]
name = "AI21"
command = x,x,x,x,x,x,x,x,x,x,x,x,x,x,x,x,x,x,x
time = 0
[Command]
name = "AI22"
command = y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y
time = 0
[Command]
name = "AI23"
command = z,z,z,z,z,z,z,z,z,z,z,z,z,z,z,z,z,z,z
time = 0
[Command]
name = "AI24"
command = s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s
time = 0
[Command]
name = "AI25"
command = F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F
time = 0
[Command]
name = "AI26"
command = D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D
time = 0
[Command]
name = "AI27"
command = B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B
time = 0
[Command]
name = "AI28"
command = U,U,U,U,U,U,U,U,U,U,U,U,U,U,U,U,U,U,U
time = 0
[Command]
name = "AI29"
command = a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a
time = 0
[Command]
name = "AI30"
command = c,c,c,c,c,c,c,c,c,c,c,c,c,c,c,c,c,c,c
time = 0
[Command]
name = "AI31"
command = x,x,x,x,x,x,x,x,x,x,x,x,x,x,x,x,x,x,x
time = 0
[Command]
name = "AI32"
command = y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y
time = 0
[Command]
name = "AI33"
command = z,z,z,z,z,z,z,z,z,z,z,z,z,z,z,z,z,z,z
time = 0
[Command]
name = "AI34"
command = s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s
time = 0
[Command]
name = "AI35"
command = z,z,z,z,z,z,z,z,z,z,z,z,z,z,z,z,z,z,z
time = 0
[Command]
name = "AI36"
command = z,z,z,z,z,z,a,a,a,z,z,z,z,z,z,z,z,z,z
time = 0
[Command]
name = "AI37"
command = z,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,z,z,z
time = 0
[Command]
name = "AI38"
command = z,z,z,z,z,a,a,a,z,z,z,z,z,a,a,a,z,z,z
time = 0
[Command]
name = "AI39"
command = z,z,z,z,z,a,a,a,z,z,z,z,z,z,a,a,z,z,z
time = 0
[Command]
name = "AI40"
command = z,z,z,z,a,a,a,z,z,z,z,a,z,z,a,a,z,z,z
time = 0
[Command]
name = "AI41"
command = z,z,z,a,z,z,z,z,z,z,z,z,z,a,a,z,z,z,z
time = 0
[Command]
name = "AI42"
command = z,z,z,z,z,z,z,z,z,z,z,z,z,z,z,z,z,z,z
time = 0
[Command]
name = "AI43"
command = z,z,z,z,z,z,z,z,z,z,z,z,z,z,z,z,a,a,z
time = 0
[Command]
name = "AI44"
command = z,z,a,a,a,a,z,z,z,z,z,z,z,z,z,a,a,a,z
time = 0
[Command]
name = "AI45"
command = z,z,z,z,z,z,a,a,z,z,z,z,z,a,a,a,a,z,z
time = 0
[Command]
name = "AI46"
command = z,z,z,z,z,z,z,z,a,a,a,a,a,a,z,z,z,z,z
time = 0
[Command]
name = "AI47"
command = z,z,z,a,a,a,a,z,z,z,z,z,z,z,z,z,z,z,z
time = 0
[Command]
name = "AI48"
command = z,z,z,z,z,a,a,a,z,z,z,a,a,a,z,z,a,z,a
time = 0
[Command]
name = "AI49"
command = z,z,z,z,a,a,a,z,z,z,z,z,a,a,a,z,z,z,z
time = 0
[Command]
name = "AI50"
command = z,z,z,a,a,z,z,z,z,z,z,z,z,z,a,a,z,z,z
time = 0

;-| Button Remapping |-----------------------------------------------------
; This section lets you remap the player's buttons (to easily change the
; button configuration). The format is:
;   old_button = new_button
; If new_button is left blank, the button cannot be pressed.
[Remap]
x = x
y = y
z = z
a = a
b = b
c = c
s = s

;-| Default Values |-------------------------------------------------------
[Defaults]
; Default value for the "time" parameter of a Command. Minimum 1.
command.time = 15

; Default value for the "buffer.time" parameter of a Command. Minimum 1,
; maximum 30.
command.buffer.time = 1


;-| Super Motions |--------------------------------------------------------
;The following two have the same name, but different motion.
;Either one will be detected by a "command = TripleKFPalm" trigger.
;Time is set to 20 (instead of default of 15) to make the move
;easier to do.
;

;-| Breaker, Hit Thech |----------------------------------------------------
[Command]
name = "Breaker"
command = x+y+a+b
time = 15

[Command]
name = "Hit Tech"
command = y+b+z+c
time = 15

;---------------------------------------------------------------------------

[Command]
name = "TripleKFPalm"
command = ~D, DF, F, x+y
time = 20

[Command]
name = "TripleKFPalm"
command = ~D, DF, F, x+z
time = 20

[Command]
name = "TripleKFPalm"
command = ~D, DF, F, y+z
time = 20

[Command]
name = "QCF_ab"
command = ~D, DF, F, a+b

[Command]
name = "QCF_ab"
command = ~D, DF, F, a+c

[Command]
name = "QCF_ab"
command = ~D, DF, F, b+c

[Command]
name = "Suicide Bombing"
command = ~D, DB, B, a+b

[Command]
name = "Suicide Bombing"
command = ~D, DB, B, a+c

[Command]
name = "Suicide Bombing"
command = ~D, DB, B, b+c

[Command]
name = "Breaker"
command = ~x+y+a+b
time = 15

;-| Special Motions |------------------------------------------------------
[Command]
name = "QCF_x"
command = ~D, DF, F, x

[Command]
name = "QCF_y"
command = ~D, DF, F, y

[Command]
name = "QCF_z"
command = ~D, DF, F, z

[Command]
name = "Surprise!"
command = ~D, DB, B, x

[Command]
name = "Surprise!"
command = ~D, DB, B, y

[Command]
name = "Surprise!"
command = ~D, DB, B, z

[Command]
name = "Teleport Left"
command = ~D, DB, B, a

[Command]
name = "Teleport Med"
command = ~D, DB, B, b

[Command]
name = "Teleport Right"
command = ~D, DB, B, c

[Command]
name = "Air Bomb"
command = ~D, DF, F, x

[Command]
name = "Air Bomb"
command = ~D, DF, F, y

[Command]
name = "Air Bomb"
command = ~D, DF, F, z

[Command]
name = "Yojimbo Slash"
command = ~F, D, DF, x

[Command]
name = "Yojimbo Slash"
command = ~F, D, DF, y

[Command]
name = "Yojimbo Slash"
command = ~F, D, DF, z

[Command]
name = "Magnum 1"
command = ~F, D, DF, a

[Command]
name = "Magnum 2"
command = ~F, D, DF, b

[Command]
name = "Magnum 3"
command = ~F, D, DF, c


[Command]
name = "QCF_xy"
command = ~D, DF, F, x+y

;-| Guard Push | ---------------------------------------------------------- \
[Command]
name = "GuardPush1";Required (do not remove)
command = x+y
time = 10

[Command]
name = "GuardPush2";Required (do not remove)
command = y+z
time = 10

;-| Double Tap |-----------------------------------------------------------
[Command]
name = "FF"     ;Required (do not remove)
command = F, F
time = 10

[Command]
name = "BB"     ;Required (do not remove)
command = B, B
time = 10

;-| 2/3 Button Combination |-----------------------------------------------
[Command]
name = "recovery";Required (do not remove)
command = a+b
time = 1

;-| Dir + Button |---------------------------------------------------------
[Command]
name = "down_a"
command = /$D,a
time = 1

[Command]
name = "down_b"
command = /$D,b
time = 1

;-| Single Button |---------------------------------------------------------
[Command]
name = "a"
command = a
time = 1

[Command]
name = "b"
command = b
time = 1

[Command]
name = "c"
command = c
time = 1

[Command]
name = "x"
command = x
time = 1

[Command]
name = "y"
command = y
time = 1

[Command]
name = "z"
command = z
time = 1

[Command]
name = "start"
command = s
time = 1

[Command]
name = "s"
command = s
time = 1

;-| Hold Dir |--------------------------------------------------------------
[Command]
name = "holdfwd";Required (do not remove)
command = /$F
time = 1

[Command]
name = "holdback";Required (do not remove)
command = /$B
time = 1

[Command]
name = "holdup" ;Required (do not remove)
command = /$U
time = 1

[Command]
name = "holddown";Required (do not remove)
command = /$D
time = 1

;-| Hold Dir |--------------------------------------------------------------
[Command]
name = "super_jump_up"
command = ~D, U
time = 50

;---------------------------------------------------------------------------
; 2. State entry
; --------------
; This is where you define what commands bring you to what states.
;
; Each state entry block looks like:
;   [State -1, Label]           ;Change Label to any name you want to use to
;                               ;identify the state with.
;   type = ChangeState          ;Don't change this
;   value = new_state_number
;   trigger1 = command = command_name
;   . . .  (any additional triggers)
;
; - new_state_number is the number of the state to change to
; - command_name is the name of the command (from the section above)
; - Useful triggers to know:
;   - statetype
;       S, C or A : current state-type of player (stand, crouch, air)
;   - ctrl
;       0 or 1 : 1 if player has control. Unless "interrupting" another
;                move, you'll want ctrl = 1
;   - stateno
;       number of state player is in - useful for "move interrupts"
;   - movecontact
;       0 or 1 : 1 if player's last attack touched the opponent
;                useful for "move interrupts"
;
; Note: The order of state entry is important.
;   State entry with a certain command must come before another state
;   entry with a command that is the subset of the first.
;   For example, command "fwd_a" must be listed before "a", and
;   "fwd_ab" should come before both of the others.
;
; For reference on triggers, see CNS documentation.
;
; Just for your information (skip if you're not interested):
; This part is an extension of the CNS. "State -1" is a special state
; that is executed once every game-tick, regardless of what other state
; you are in.


; Don't remove the following line. It's required by the CMD standard.
[Statedef -1]

;-|-AI-|--------------------------------------------------------------------
[State -1, AI]
type = VarSet
trigger1 = var(59)
var(57) = 2

[State -1, Guard Transition ON/OFF]
type = VarSet
trigger1 = var(59)
var(3) = 1
;===========================================================================







;===========================================================================
;                             AI COMMAND
;===========================================================================




;---------------------------------------------------------------------------
;Suicide Bombing
[State -1, Suicide Bombing]
type = ChangeState
value = 3200
triggerall = RoundState = 2 && var(59)
triggerall = StateType != A
triggerall = enemynear,statetype != L
triggerall = enemynear,stateno != [5100,5120]
triggerall = enemynear,anim!=5120
triggerall = power >= 1000
triggerall = ctrl || (stateno = [120,140]) || prevstateno = 5120
triggerall = stateno != [150,155]
triggerall = P2bodydist X = [-58,61]
triggerall = enemynear,Pos Y > -117
triggerall = enemynear,vel Y > -1  
triggerall = enemynear,stateno != [800,899]
triggerall = enemynear,stateno != [9020,9030]
triggerall = enemynear,hitdefattr = SCA,AA,AT ;triggerall = random < 60
triggerall = enemynear,time <= 10
triggerall = !numhelper(1845)
triggerall = random < 100 && Life <= Lifemax/2
trigger1 = enemynear,facing != facing
trigger1 = enemynear,movetype = A
trigger1 = inguarddist
trigger2 = Facing = enemy,facing
trigger2 = P2bodydist X < 0
trigger2 = !inguarddist
trigger2 = helper(19319),inguarddist || helper(19320),inguarddist
trigger2 = enemy,p2dist x < 0 

;---------------------------------------------------------------------------
;Escape from Throw
[State -1, Escape from Throw]
type = ChangeState
value = 627
triggerall = var(59)
Triggerall = (RoundState = 2)
Triggerall = StateType != L
triggerall = enemynear,statetype != L
triggerall = enemynear,stateno != [5100,5120]
triggerall = enemynear,anim!=5120
triggerall = statetype != A
triggerall = enemynear, Facing != Facing
triggerall = !numhelper(1845)
triggerall = random < 100
trigger1 = ctrl || (stateno = [120,140])
trigger1 = enemynear,stateno = [800,899]
trigger1 = P2bodydist X = [0,70]
trigger1 = enemynear,hitdefattr = SCA,AT
trigger1 = inguarddist

;---------------------------------------------------------------------------
;R E J E C T   P A R R Y  (Yojimbo Slash)
[State -1, R E J E C T   P A R R Y  (Yojimbo Slash)]
type = ChangeState
value = 1250
triggerall = RoundState = 2 && var(59)
triggerall = StateType != A
triggerall = enemynear,statetype != L
triggerall = enemynear,stateno != [5100,5120]
triggerall = enemynear,anim!=5120
triggerall = movetype != H
triggerall = enemynear,movetype = A
trigger1 = var(51) != 0
trigger1 = P2bodydist X = [-1,70] ;[0,70];65]

;---------------------------------------------------------------------------
;R E J E C T   P A R R Y  (Bullet Fury)
[State -1, R E J E C T   P A R R Y  (Bullet Fury)]
type = ChangeState
value = 3000
triggerall = RoundState = 2 && var(59)
triggerall = StateType != A
triggerall = enemynear,statetype != L
triggerall = enemynear,stateno != [5100,5120]
triggerall = enemynear,anim!=5120
triggerall = power >= 1000
triggerall = movetype != H
triggerall = var(51) != 0
trigger1 = enemynear,movetype = A
trigger1 = P2bodydist X > 70
;trigger1 = stateno != 250 && stateno != 250 && stateno != 440
;trigger2 = stateno = 250 || stateno = 256 || stateno = 440

;---------------------------------------------------------------------------
;R E J E C T   P A R R Y  (Magnum)
[State -1, R E J E C T   P A R R Y  (Magnum)]
type = ChangeState
value = 1500
triggerall = RoundState = 2 && var(59)
triggerall = StateType != A
triggerall = enemynear,statetype != L
triggerall = enemynear,stateno != [5100,5120]
triggerall = enemynear,anim!=5120
triggerall = enemynear,pos Y >= -25
triggerall = power < 1000
triggerall = movetype != H
trigger1 = enemynear,movetype = A
triggerall = var(51) != 0
trigger1 = P2bodydist X > 70
;trigger1 = stateno != 250 && stateno != 250 && stateno != 440
;trigger2 = stateno = 250 || stateno = 256 || stateno = 440

;---------------------------------------------------------------------------
;R E J E C T   P A R R Y  (Assult Rifle)
[State -1, R E J E C T   P A R R Y  (Assult Rifle)]
type = ChangeState
value = 1000
triggerall = RoundState = 2 && var(59)
triggerall = StateType != A
triggerall = enemynear,statetype != L
triggerall = enemynear,stateno != [5100,5120]
triggerall = enemynear,anim!=5120
triggerall = power < 1000
triggerall = var(51) != 0
triggerall = enemynear,pos Y = [-90,-25]
triggerall = movetype != H
trigger1 = enemynear,movetype = A
trigger1 = P2bodydist X > 70
;trigger1 = stateno != 250 && stateno != 250 && stateno != 440
;trigger2 = stateno = 250 || stateno = 256 || stateno = 440


;---------------------------------------------------------------------------
;Yojimbo Slash \
[State -1, Yojimbo Slash]
type = ChangeState
value = 1200
triggerall = RoundState = 2 && var(59)
triggerall = StateType != A
triggerall = enemynear,statetype != L
triggerall = enemynear,stateno != [5100,5120]
triggerall = enemynear,anim!=5120
triggerall = enemynear,stateno != [5520,5550]
triggerall = !var(11) ;!var(55)
triggerall = !numhelper(651)
triggerall = !numhelper(1845)
triggerall = enemynear,stateno != [9020,9030]
triggerall = enemynear,movetype != H
triggerall = stateno != [150,155]
triggerall = ctrl || (stateno = [120,140]) || prevstateno = 5120
triggerall = random < 25 && Life > Lifemax/2 || random < 70 && Life <= Lifemax/2
trigger1 = enemynear,Pos Y > -95
trigger1 = enemynear,vel Y > -1
trigger1 = P2bodydist X = [1,30] ;[0,30]
trigger1 = enemynear,movetype = A
trigger1 = inguarddist
trigger2 = enemynear,pos Y > -164
trigger2 = P2bodydist X = [31,55]
trigger2 = enemynear,movetype = A
trigger2 = inguarddist
trigger2 = enemynear,stateno != 200 && enemynear,stateno != 230 && enemynear,stateno != 400 && enemynear,stateno != 430 && enemynear,stateno != 600 && enemynear,stateno != 630 && (enemynear,stateno != [800,899])
trigger2 = enemynear,time <= 10
trigger3 = P2bodydist X = [31,65]
trigger3 = enemynear,vel X > 4
trigger3 = enemynear,pos Y = [-164,-85] ;[-145,-85] ;\

;---------------------------------------------------------------------------
;Escape from Throw
[State -1, Escape from Throw]
type = ChangeState
value = 627
triggerall = var(59)
triggerall = !numhelper(1845)
Triggerall = (RoundState = 2)
Triggerall = StateType != L
triggerall = enemynear,statetype != L
triggerall = enemynear,stateno != [5100,5120]
triggerall = enemynear,anim!=5120
triggerall = statetype != A
triggerall = enemynear, Facing != Facing
triggerall = random < 200
trigger1 = ctrl || (stateno = [120,140])
trigger1 = enemynear,stateno != [800,899]
trigger1 = P2bodydist X = [0,100]
trigger1 = enemynear,hitdefattr = SCA,AT
trigger1 = inguarddist

;---------------------------------------------------------------------------
[State -1, Throw]
type = ChangeState
value = 800
triggerall = RoundState = 2 && var(59)
triggerall = StateType != A
triggerall = enemynear,statetype != L
triggerall = enemynear,stateno != [5100,5120]
triggerall = enemynear,anim!=5120
triggerall = enemynear,statetype != A
triggerall = enemynear,movetype != H
triggerall = !numhelper(1845)
triggerall = enemynear,stateno != [9020,9030]
triggerall = !var(11) ;!var(55)
triggerall = ctrl
triggerall = P2bodydist X = [-1,15]
trigger1 = random < 30 && Life > Lifemax/2
trigger2 = random < 100 && Life <= Lifemax/2

;---------------------------------------------------------------------------
;Fake Gamma Charge
[State -1, Fake Gamma Charge]
type = ChangeState
value = 3100
triggerall = RoundState = 2 && var(59)
triggerall = StateType != A
triggerall = enemynear,statetype != L
triggerall = enemynear,stateno != [5100,5120]
triggerall = enemynear,anim!=5120
triggerall = power >= 1000
triggerall = enemynear,Pos Y > -128
triggerall = enemynear,vel Y > -1
triggerall = !numhelper(1845)
triggerall = enemynear,stateno != [9020,9030]
triggerall = random < 100 && Life <= Lifemax/2
trigger1 = enemynear,time <= 10
trigger1 = ctrl || (stateno = [120,141])
trigger1 = P2bodydist X = [130,250]
trigger1 = enemynear,numproj > 0 && enemynear,movetype = A || (enemynear,stateno = [1000,3999]) && enemynear,movetype != H

;triggerall = enemynear,hitdefattr = SCA,AA,AT
;(enemynear,numproj = [1,2])

;---------------------------------------------------------------------------
;Fake Gamma Charge/(or BUlletFury) Reversal 1 \
[State -1, Fake Gamma Charge]
type = ChangeState
value = ifelse(numhelper(31088)=0,3108,3008)
triggerall = power >= 1000
triggerall = var(12) < 2
triggerall = RoundState = 2 && var(59) && StateType != A
triggerall = enemynear,statetype != L && enemynear,anim!=5120
triggerall = enemynear,stateno != [5100,5120] 
triggerall = enemynear,Pos Y > -128 && enemynear,vel Y > -4
triggerall = !numhelper(1845) && !var(11)
triggerall = enemynear,stateno != [9020,9030]
triggerall = stateno = 151 && ctrl || stateno = 153 && ctrl || prevstateno = 151 && (stateno = [130,131]) || prevstateno = 153 && (stateno = [130,131]) || stateno = 464 && animtime = -1
triggerall = random < 100
trigger1 = P2bodydist X > 160
trigger1 = Life >= 200

;---------------------------------------------------------------------------
;Fake Gamma Charge Reversal 2 \
[State -1, Fake Gamma Charge]
type = ChangeState
value = ifelse(numhelper(31088)=0,3108,3008)
triggerall = power >= 1000
triggerall = var(12) < 2
triggerall = P2bodydist X = [100,215]
triggerall = RoundState = 2 && var(59) && StateType != A
triggerall = enemynear,statetype != L && enemynear,anim!=5120
triggerall = enemynear,stateno != [5100,5120] 
triggerall = enemynear,Pos Y > -128 && enemynear,vel Y > -4
triggerall = !numhelper(1845) && !var(11)
triggerall = enemynear,stateno != [9020,9030]
triggerall = stateno = 151 && ctrl || stateno = 153 && ctrl || prevstateno = 151 && (stateno = [130,131]) || prevstateno = 153 && (stateno = [130,131]) || stateno = 464 && animtime = -1
triggerall = random < 100
trigger1 = var(12) = 0
trigger2 = enemynear,animtime >= -5 && var(12) >= 1 && (Life = [200,600])
trigger3 = !inguarddist && var(12) >= 1 && (Life = [200,600])
trigger4 = enemynear,numproj = 0 && var(12) >= 1 && (Life = [200,600])
trigger5 = enemynear,movetype = I && var(12) >= 1 && (Life = [200,600])

;triggerall = enemynear,stateno != 200 && enemynear,stateno != 230 && enemynear,stateno != 400 && enemynear,stateno != 430 && enemynear,stateno != 600 && enemynear,stateno != 630 && (enemynear,stateno != [800,899])

;---------------------------------------------------------------------------
;11100 (Guard => Reversal) \
[State -1, 11100 (Guard => Reversal)]
type = ChangeState
value = 2100
triggerall = RoundState = 2 && var(59)
triggerall = StateType != A
triggerall = var(12) < 2
triggerall = enemynear,statetype != L && enemynear,anim!=5120
triggerall = (enemynear,stateno != [5100,5120]) && (enemynear,stateno != [9020,9030])
triggerall = !numhelper(1845) && !var(11)
triggerall = enemynear,Pos Y > -117 && enemynear,vel Y > -1
triggerall = enemynear,numproj = 0
triggerall = (P2bodydist X = [70,140]) && random > 899 || (P2bodydist X = [141,160]) && (random = [600,699])
triggerall = stateno = 151 && ctrl || stateno = 153 && ctrl || prevstateno = 151 && (stateno = [130,131]) || prevstateno = 153 && (stateno = [130,131]) || stateno = 464 && animtime = -1
trigger1 = var(12) = 0 && Life >= 200 
trigger2 = var(12) = 1 && Life >= 300 && power < 1000
trigger2 = enemynear,movetype =I
trigger3 = var(12) = 1 && Life >= 200 && power < 1000
trigger3 = enemynear,animtime <= -20 
trigger3 = enemynear,hitdefattr = SCA,AA,AT,AP || enemynear,stateno < 3000
trigger4 = var(12) = 1 && Life >= 300 && power < 1000

;triggerall = enemynear,stateno != 200 && enemynear,stateno != 230 && enemynear,stateno != 400 && enemynear,stateno != 430 && enemynear,stateno != 600 && enemynear,stateno != 630 && (enemynear,stateno != [800,899])
;enemynear,movetype = A ;enemynear,hitdefattr = SCA,AA,AT
;triggerall = enemynear,time > 10 || enemynear,animtime <= -20
;triggerall = power < 1500

;---------------------------------------------------------------------------
;2500 (Guard => Reversal) \
[State -1, 2500 (Guard => Reversal)]
type = ChangeState
value = 2500
triggerall = RoundState = 2 && var(59)
triggerall = StateType != A
triggerall = var(12) < 2
triggerall = enemynear,statetype != L && enemynear,anim!=5120
triggerall = enemynear,stateno != [5100,5120]
triggerall = !numhelper(1845)
triggerall = !var(11)
triggerall = enemynear,stateno != [9020,9030]
triggerall = enemynear,Pos Y > -110 && enemynear,vel Y > -1
triggerall = enemynear,numproj = 0
triggerall = (P2bodydist X = [70,140]) && (random = [500,599])
triggerall = var(12) = 0 && Life >= 200 || var(12) = 1 && Life >= 300 && power < 1000
trigger1 = stateno = 151 || stateno = 153
trigger1 = ctrl
trigger2 = prevstateno = 151 || prevstateno = 153
trigger2 = stateno = 130 || stateno = 131
trigger3 = stateno = 464 && animtime = -1

; = enemynear,stateno != 200 && enemynear,stateno != 230 && enemynear,stateno != 400 && enemynear,stateno != 430 && enemynear,stateno != 600 && enemynear,stateno != 630 && (enemynear,stateno != [800,899])
;triggerall = enemynear,time > 10 || enemynear,animtime <= -17
;triggerall = power < 1500

;---------------------------------------------------------------------------
;Bullet Fury \
[State -1, Bullet Fury]
type = ChangeState
value = 3008
triggerall = var(12) < 3
triggerall = power >= 1000
triggerall = RoundState = 2 && var(59) && StateType != A
triggerall = enemynear,statetype != L && enemynear,anim!=5120
triggerall = (enemynear,stateno != [5100,5120]) && (enemynear,stateno != [9020,9030])
triggerall = !numhelper(3154) && !numhelper(5888) && !numhelper(1845) && !var(11)
triggerall = enemynear,Pos Y > -160 && enemynear,vel Y > -1
triggerall = P2bodydist X > 120 && var(12) > 1 || P2bodydist X > 70 && var(12) = 0
triggerall = random = [300,399]
trigger1 = numhelper(466) > 0 || prevstateno = 464
trigger1 = P2dist X > 0 && (stateno != [2100,2110]) && (stateno != [2500,2550]) && (stateno != [3008,3110]) && movetype != H 
trigger2 = stateno = 151 && ctrl 
trigger3 = stateno = 153 && ctrl 
trigger4 = prevstateno = 151 && (stateno = [130,131]) 
trigger5 = prevstateno = 153 && (stateno = [130,131]) 
trigger6 = stateno = 464 && animtime = -1

;---------------------------------------------------------------------------
;Spin
[State -1, Spin]
type = ChangeState
value = 1320
triggerall = var(59)
Triggerall = (RoundState = 2)
Triggerall = StateType != L
triggerall = enemynear,statetype != L
triggerall = enemynear,stateno != [5100,5120]
triggerall = enemynear,anim!=5120
triggerall = statetype != A
triggerall = enemynear, Facing != Facing
triggerall = !numhelper(1845)
triggerall = enemynear,stateno != [9020,9030]
triggerall = random >= 930 ;< 70
trigger1 = enemynear,time <= 10
trigger1 = ctrl || (stateno = [120,141])
trigger1 = P2bodydist X > 130
trigger1 = enemynear,numproj > 0 && enemynear,movetype = A || (enemynear,stateno = [1000,3999]) && enemynear,movetype != H



;===========================================================================
;GUARD/BLOCK CODE
;===========================================================================


[State -1, Guard Push]
type = ChangeState
value = 464
triggerall = var(59)
triggerall = statetype != A
triggerall = enemynear, Facing != Facing
triggerall = (stateno = [150,155]) 
trigger1 = enemynear, vel X > 4
trigger2 = !(enemynear,hitdefattr = SCA, AA,AT)
ignorehitpause = 1

[State -1, Guard Push, AIR]
type = ChangeState
value = 474
triggerall = var(59)
triggerall = statetype = A
triggerall = enemynear, Facing != Facing
triggerall = P2bodydist X = [-30,50]
trigger1 = (stateno = [150,155]) ;triggerall = stateno != [464,474]
ignorehitpause = 1


[State -1, CrouchGuard, NA,SA,HA]
type = ChangeState
value = 131
triggerall = var(59) 
triggerall = roundstate = 2
triggerall = random <= 999
triggerall = (StateType != A) &&  (enemynear, Facing != Facing)  
triggerall = (enemynear,StateType != A) 
triggerall = !enemynear,hitdefattr = SCA,NT,ST,HT
trigger1 = stateno != [464,474]
trigger1 = inguarddist 
trigger1 = (stateno = [100,107]) || ctrl ;|| stateno = 0 && prevstateno = 103
trigger2 = stateno = 120 && statetype = S || stateno = 130 || stateno = 140 && statetype = S
trigger2 = inguarddist
trigger2 = enemynear,statetype = C || enemynear,hitdefattr = C,NA,SA,HA


[State -1, CrouchGuard, For Behind]
type = ChangeState
value = 131
triggerall = var(59) 
triggerall = roundstate = 2
triggerall = random <= 999
triggerall = (StateType != A)
triggerall = (enemynear,StateType != A) 
triggerall = !enemynear,hitdefattr = SCA,NT,ST,HT
triggerall = stateno != [464,474]
triggerall = !inguarddist
triggerall = helper(19319),inguarddist || helper(19320),inguarddist
triggerall = enemy,p2dist x < 0 
triggerall = Facing = enemy,facing
trigger1 = ctrl  ;trigger1 = random >= 850 || (enemynear,stateno = [120,155])
trigger2 = stateno = [100,107]


[State -1, S Guard, NA,SA,HA]
type = ChangeState
value = 130
triggerall = var(59) 
triggerall = roundstate = 2
triggerall = random <= 999
triggerall = (StateType != A) &&  (enemynear, Facing != Facing)  
triggerall = (enemynear,StateType = A) 
triggerall = enemynear,hitdefattr != SCA,NT,ST,HT
trigger1 = stateno != [464,474]
trigger1 = inguarddist 
trigger1 = (stateno = [100,107]) || ctrl
trigger2 = stateno = 120 && statetype = C || stateno = 131 || stateno = 140 && statetype = C
trigger2 = inguarddist
trigger2 = enemynear,statetype = A || enemynear,hitdefattr = A,NA,SA,HA

[State -1, S Guard, For Behind]
type = ChangeState
value = 130
triggerall = var(59) 
triggerall = roundstate = 2
triggerall = random <= 999
triggerall = (StateType != A)
triggerall = (enemynear,StateType = A) 
triggerall = enemynear,hitdefattr != SCA,NT,ST,HT
triggerall = stateno != [464,474]
triggerall = !inguarddist
triggerall = helper(19319),inguarddist || helper(19320),inguarddist
triggerall = enemy,p2dist x < 0 
triggerall = Facing = enemy,facing
trigger1 = ctrl
trigger2 = stateno = [100,107]


[State -1, A Guard, NA,SA,HA]
type = ChangeState
value = 132
triggerall = var(59) 
triggerall = roundstate = 2
triggerall = random <= 999
triggerall = (StateType = A) &&  (enemynear, Facing != Facing)  
triggerall = !enemynear,hitdefattr = SCA,NT,ST,HT
trigger1 = stateno != [464,474]
trigger1 = inguarddist 
trigger1 = ctrl

[State -1, A Guard, For Behind]
type = ChangeState
value = 132
triggerall = var(59) 
triggerall = roundstate = 2
triggerall = random <= 999
triggerall = (StateType = A)
triggerall = !enemynear,hitdefattr = SCA,NT,ST,HT
triggerall = stateno != [464,474]
triggerall = !inguarddist
triggerall = helper(19319),inguarddist || helper(19320),inguarddist
triggerall = enemy,p2dist x < 0 
triggerall = Facing = enemy,facing
trigger1 = ctrl

;==========================================================================



;---------------------------------------------------------------------------
;Stand Weak Punch
[State -1, Stand Weak Punch]
type = ChangeState
value = ifelse(Life>Lifemax/2,420,ifelse(power>=1000,3000,420))
triggerall = RoundState = 2 && var(59)
triggerall = StateType != A
triggerall = enemynear,statetype != L
triggerall = enemynear,stateno != [5100,5120]
triggerall = enemynear,anim!=5120
trigger1 = enemynear,stateno != [5600,5650]
trigger1 = var(21) = 1
trigger1 = ctrl || anim = 100 && (enemynear,stateno != [5600,5650]) ;|| stateno = 1025
trigger1 = P2bodydist X = [-10,55]
trigger1 = enemynear,Pos Y = [-140,-40]

;---------------------------------------------------------------------------
;Bullet Fury
[State -1, Bullet Fury]
type = ChangeState
value = 3000
triggerall = RoundState = 2 && var(59)
triggerall = StateType != A
triggerall = enemynear,statetype != L
triggerall = enemynear,stateno != [5100,5120]
triggerall = enemynear,anim!=5120
triggerall = power >= 1000
triggerall = !numhelper(3154)
triggerall = enemynear,stateno != [9020,9030]
trigger1 = !numhelper(5888)
trigger1 = !var(11) ;!var(55)
trigger1 = enemynear,stateno != 5820
trigger1 = (enemynear,stateno != [150,153]) || (enemynear,stateno = [150,153]) && enemynear,life <= 50
trigger1 = numhelper(451)+numhelper(1024) <= 1
trigger1 = ctrl
trigger1 = P2bodydist X > 140
trigger1 = enemynear,Pos Y > -160
trigger1 = enemynear,vel Y > -1
trigger1 = random < 75
trigger2 = anim = 1011 && animtime = -1 || ctrl = 1 || (stateno = [450,1510]) && time <= 6
trigger2 = (ProjhitTime(1019)>-1 && ProjhittIme(1019)<26)
trigger2 = enemynear,stateno = [5020,5050]
trigger2 = P2bodydist X > 195 ;45
trigger2 = enemynear,vel Y < 0 || enemynear,vel Y >= 0 && enemynear,pos Y < -50
;trigger3 = stateno != 3000
;trigger3 = var(6)

;---------------------------------------------------------------------------
;Yojimbo Slash (Combo)
[State -1, Yojimbo Slash (Combo)]
type = ChangeState
value = 1200
triggerall = RoundState = 2 && var(59)
triggerall = StateType != A
triggerall = enemynear,statetype != L
triggerall = enemynear,stateno != [5100,5120]
triggerall = enemynear,anim!=5120
triggerall = stateno = 101 || ctrl = 1
triggerall = P2bodydist X = [0,45]
trigger1 = numhelper(1108) > 0 || numhelper(1029) > 0
trigger1 = enemynear,stateno != [5520,5550]
trigger2 = enemynear,stateno = 3280
trigger2 = enemynear,Pos Y = [-400,-150]

;---------------------------------------------------------------------------
;Run Back 9020
[State -1, Run Back 9020]
type = ChangeState
value = 107
triggerall = RoundState = 2 && var(59)
triggerall = StateType != A
triggerall = !numhelper(1845)
trigger1 = ctrl
trigger1 = enemynear,stateno = [9020,9030]
trigger1 = P2bodydist X = [0,110]

;---------------------------------------------------------------------------
;Run Fwd 9020
[State -1, Run Fwd 9020]
type = ChangeState
value = 102
triggerall = RoundState = 2 && var(59)
triggerall = StateType != A
triggerall = !numhelper(1845)
trigger1 = ctrl
trigger1 = enemynear,stateno = [9020,9030]
trigger1 = P2bodydist X = [-110,-1]

;---------------------------------------------------------------------------
;Run Fwd Enemy,5820 \
[State -1, Run Fwd Enemy,5820]
type = ChangeState
value = 103
triggerall = RoundState = 2 && var(59)
triggerall = StateType != A
triggerall = !numhelper(1845)
trigger1 = stateno = 52 && animtime = -1
trigger1 = enemynear,stateno = 5820
trigger1 = P2bodydist X >= 80

;---------------------------------------------------------------------------
;Bomb 9020
[State -1, Bomb 9020]
type = ChangeState
value = 450
triggerall = RoundState = 2 && var(59)
triggerall = StateType != A
triggerall = !numhelper(1845)
triggerall = numhelper(451) < 1
trigger1 = ctrl || stateno = 107
trigger1 = enemynear,stateno = [9020,9030]
trigger1 = P2bodydist X > 110

;---------------------------------------------------------------------------
;Run Fwd
[State -1, Run Fwd]
type = ChangeState
value = 101
triggerall = RoundState = 2 && var(59)
triggerall = StateType != A
triggerall = enemynear,statetype != L
triggerall = enemynear,stateno != [5100,5120]
triggerall = enemynear,anim!=5120
trigger1 = stateno = 1100 || stateno = 285 || stateno = 2110
trigger1 = movehit && animtime = -1
trigger1 = enemynear,movetype = H
trigger1 = enemynear,stateno != [150,155]
trigger2 = ctrl
trigger2 = enemynear,stateno = 3280
trigger2 = P2bodydist X >= 45
trigger3 = P2bodydist X >= 35
trigger3 = numhelper(5625) > 0

;trigger2 = ctrl
;trigger2 = helper(1024),movehit || helper(1027),movehit
;trigger2 = enemynear,movetype = H
;trigger2 = enemynear,stateno != [150,155]
;trigger2 = P2bodydist X >= 45

;---------------------------------------------------------------------------
;Run Fwd
[State -1, Run Fwd]
type = ChangeState
value = ifelse(Life<=Lifemax*0.4,101,1000)
triggerall = RoundState = 2 && var(59)
triggerall = StateType != A
triggerall = enemynear,statetype != L
triggerall = enemynear,stateno != [5100,5120]
triggerall = enemynear,anim!=5120
trigger1 = ctrl
trigger1 = helper(1024),movehit || helper(1027),movehit
trigger1 = enemynear,movetype = H
trigger1 = enemynear,stateno != [150,155]
trigger1 = P2bodydist X >= 45

;---------------------------------------------------------------------------
;Run Back
;ރ_bV
[State -1, Run Back (Combo)]
type = ChangeState
value = 105
triggerall = RoundState = 2 && var(59)
triggerall = StateType != A
triggerall = stateno = 101 || ctrl
triggerall = P2bodydist X <= 0 ;-1
trigger1 = enemynear,stateno = [5520,5550]
trigger2 = enemynear,stateno = 5820
trigger3 = enemynear,stateno = 3280

;---------------------------------------------------------------------------
;Run Back
;ރ_bV
[State -1, Run Back (if 1025 dosnt work)]
type = ChangeState
value = 107
triggerall = RoundState = 2 && var(59)
triggerall = StateType != A
triggerall = stateno = 101 || ctrl
triggerall = P2bodydist X = [-10,70]
trigger1 = (enemynear,stateno = [5100,5110]) || enemynear,stateno = 5432 || enemynear,stateno = 5310

;---------------------------------------------------------------------------
;Run Back, enemy rolling
[State -1, Run Back, enemy rolling]
type = ChangeState
value = 107
triggerall = RoundState = 2 && var(59)
triggerall = StateType != A
triggerall = enemynear,stateno != [5100,5120]
triggerall = enemynear,anim!=5120
triggerall = ctrl
trigger1 = P2bodydist X = [-10,70]
trigger1 = enemynear,prevstateno = 5110 || enemynear,prevstateno = 5120
trigger1 = enemynear,statetype != A
trigger1 = enemynear,movetype != A
trigger1 = enemynear,vel X < 0

;---------------------------------------------------------------------------
;Gunfire 3, for 5100 - 5110
[State -1, Gunfire 3, for 5100 - 5110]
type = ChangeState
value = 1025
triggerall = RoundState = 2 && var(59)
triggerall = StateType != A
triggerall = numhelper(1024) < 2
triggerall = ctrl || stateno = 52
triggerall = (enemynear,stateno = [5100,5110]) || enemynear,stateno = 5432 || enemynear,stateno = 5310
triggerall = Life <= Lifemax*0.4 && random < 100 ;@
trigger1 = frontedgedist > 100
trigger1 = P2bodydist X = [0,83]
trigger2 = frontedgedist <= 100
trigger2 = P2bodydist X = [-10,83]

;---------------------------------------------------------------------------
;3000 => Gunfire 3
[State -1, 3000 => Gunfire 3]
type = ChangeState
value = 1025
triggerall = RoundState = 2 && var(59)
triggerall = StateType != A
triggerall = numhelper(1024) < 2
triggerall = stateno = 3001 && animtime = -1 && numhelper(3154) > 0
triggerall = Life <= Lifemax*0.4 && random < 100 ;@
trigger1 = frontedgedist > 100
trigger1 = P2bodydist X = [0,83]
trigger2 = frontedgedist <= 100
trigger2 = P2bodydist X = [-10,83]

;---------------------------------------------------------------------------
;Run Back
;ރ_bV
[State -1, Run Back]
type = ChangeState
value = ifelse(backedgedist > 50,8887,1320) ;8,1320)
triggerall = RoundState = 2 && var(59)
triggerall = StateType != A
trigger1 = P2bodydist X = [-10,100]
trigger1 = stateno = 1025 && animtime = -1
trigger1 = !numhelper(1029)

;---------------------------------------------------------------------------
;Run Back
;ރ_bV
[State -1, Run Back]
type = ChangeState
value = ifelse(backedgedist > 50,107,1320)
triggerall = RoundState = 2 && var(59)
triggerall = StateType != A
trigger1 = ctrl || stateno = 101
trigger1 = !numhelper(651)
trigger1 = P2bodydist X = [-10,70]
trigger1 = enemynear,stateno = [5100,5120]

;---------------------------------------------------------------------------
;280,Surprise! (Moveguarded =>)
[State -1, 280 (Moveguarded =>)]
type = ChangeState
value = 280
triggerall = RoundState = 2 && var(59)
triggerall = var(53) < 2
triggerall = var(53) = 0 || var(53) = 1 && enemynear,numproj = 0 || var(53) = 1 && enemynear,stateno < 3000 ;var(53) = 1 && (enemynear,vel X = [2,-3]) || 
triggerall = StateType != A
triggerall = enemynear,statetype != L && enemynear,anim!=5120 && (enemynear,stateno != [5100,5120])
triggerall = (enemynear,stateno != [9020,9030]) && !numhelper(1845) && !var(11)
triggerall = enemynear,Pos Y > -117 && enemynear,vel Y > -1
triggerall = var(8) = 0
triggerall = Life >= 200
triggerall = P2dist X > 0
triggerall = random < 33 && Life <= Lifemax/2;@
trigger1 = stateno = 240 && moveguarded
trigger2 = stateno = 260 && projguardedtime(261) = 1
trigger2 = enemynear,stateno = [130,155]
trigger2 = P2bodydist X = [65,150]
trigger3 = stateno = 250 || stateno = 2550 || stateno = 256
trigger3 = moveguarded ; P2bodydist X = [65,150]
trigger4 = stateno = 210 && moveguarded
trigger4 = enemynear,vel X < 1
trigger4 = enemynear,Pos Y < -37
trigger5 = stateno = 220 && moveguarded
trigger5 = time >= 26
trigger5 = P2bodydist X = [30,150]
trigger6 = anim = 1001 && animtime = -1
trigger6 = P2bodydist X = [30,150]
trigger6 = enemynear,stateno = [130,155]

;---------------------------------------------------------------------------
;210 => 270
[State -1, 210 => 270]
type = ChangeState
value = ifelse(Life<=Lifemax/2,270,220) ;270
triggerall = RoundState = 2 && var(59)
triggerall = StateType != A
triggerall = enemynear,statetype != L
triggerall = enemynear,stateno != [5100,5120]
triggerall = enemynear,anim!=5120
triggerall = P2bodydist X = [-1,120]
trigger1 = stateno = 210 && moveguarded
trigger1 = animtime = -1
trigger1 = enemynear,statetype = C
trigger1 = enemynear,stateno = [120,155]

;---------------------------------------------------------------------------
;620 Against Crouch Guard \
[State -1, 625]
type = ChangeState
value = 625
triggerall = RoundState = 2 && var(59)
triggerall = StateType != A
triggerall = enemynear,statetype != L
triggerall = enemynear,stateno != [5100,5120]
triggerall = enemynear,anim!=5120
triggerall = P2bodydist X = [55,170] ;[80,170]
triggerall = ctrl || stateno = 101
triggerall = !var(11) ;!var(55)
triggerall = !inguarddist
triggerall = enemynear,stateno = [152,153]
trigger1 = var(8) = 1
trigger1 = helper(1024),time <= 26
;trigger1 = helper(1024),moveguarded
;trigger1 = helper(1024),stateno = 1026

;---------------------------------------------------------------------------
;440 Against Stand Guard \
[State -1, 440 (SpikeShoe)]
type = ChangeState
value = 440
triggerall = RoundState = 2 && var(59)
triggerall = StateType != A
triggerall = enemynear,statetype != L
triggerall = enemynear,stateno != [5100,5120]
triggerall = enemynear,anim!=5120
triggerall = ctrl || stateno = 101
triggerall = enemynear,stateno = [150,151]
triggerall = !inguarddist
trigger1 = P2bodydist X = [60,110] ;[36,110]
trigger1 = var(8) = 1
trigger1 = helper(1024),time <= 26
trigger2 = P2bodydist X = [60,95] ;[36,95]
trigger2 = helper(451),moveguarded = 1

;---------------------------------------------------------------------------
;Crouch C (Bomb)
[State -1, Crouch C (Bomb)]
type = ChangeState
value = 450;5
triggerall = RoundState = 2 && var(59)
triggerall = StateType != A
triggerall = numhelper(451) < 1
triggerall = !inguarddist
trigger1 = ctrl || (stateno = [1500,1510]) && animtime = -1
trigger1 = P2bodydist X > 150
trigger1 = (enemynear,stateno = [5372,5373]) || enemynear,stateno = 5312 || enemynear,stateno = 53120 || (enemynear,stateno = [5100,5120])

;---------------------------------------------------------------------------
;Crouch C (Bomb)
[State -1, Crouch C (Bomb)]
type = ChangeState
value = 450
triggerall = RoundState = 2 && var(59)
triggerall = StateType != A
triggerall = numhelper(451) < 1
triggerall = !inguarddist
trigger1 = stateno = 450 && animtime = -1
trigger1 = P2bodydist X > 150
trigger1 = (enemynear,stateno = [5372,5373]) || enemynear,stateno = 5312 || enemynear,stateno = 53120
trigger2 = ctrl || stateno = 450 && animtime = -1 || stateno = 455 && animtime = -7
trigger2 = (P2bodydist X = [100,150])
trigger2 = (enemynear,stateno = [5372,5373]) || enemynear,stateno = 5312

;---------------------------------------------------------------------------
;250 => Launcher
[State -1, 250 => Launcher]
type = ChangeState
value = 246
triggerall = RoundState = 2 && var(59)
triggerall = StateType != A
triggerall = enemynear,statetype != L
triggerall = enemynear,stateno != [5100,5120]
triggerall = enemynear,anim!=5120
triggerall = stateno = 101 || ctrl = 1
trigger1 = P2bodydist X = [-10,40] ;51]
trigger1 = enemynear,stateno = [5600,5601]
trigger1 = enemynear,pos Y = [-120,-60] ;[-100,-60] ;20,-60]

;---------------------------------------------------------------------------
;Stand_B (Spring), Specials => Launcher 
[State -1, Stand_B, Specials => Launcher]
type = ChangeState
value = 240
triggerall = RoundState = 2 && var(59)
triggerall = StateType != A
triggerall = enemynear,statetype != L
triggerall = enemynear,stateno != [5100,5120]
triggerall = enemynear,anim!=5120
triggerall = stateno = 101 || ctrl = 1
trigger1 = P2bodydist X = [0,35] ;25] ;51]
trigger1 = numhelper(1019) > 0
trigger2 = P2bodydist X = [0,15] ;+(35*var(21))] ;15] ;25] ;35] ;45]
trigger2 = enemynear,stateno = [5520,5550]
trigger2 = enemynear,Pos Y = [-375,-300] ;63,-300] ;75,-300]
trigger3 = P2bodydist X = [0,35] ;45]
trigger3 = enemynear,stateno = 5820
trigger3 = enemynear,Pos Y = [-375,-300] ;30,-280] ;50,-280]

;---------------------------------------------------------------------------
;Fake Gamma Charge
[State -1, Fake Gamma Charge]
type = ChangeState
value = 3100
triggerall = RoundState = 2 && var(59)
triggerall = StateType != A
triggerall = enemynear,statetype != L
triggerall = enemynear,stateno != [5100,5120]
triggerall = enemynear,anim!=5120
triggerall = power >= 1000
triggerall = !var(11) ;!var(55) ;triggerall = enemynear,Pos Y > -128
triggerall = enemynear,stateno != 5820
triggerall = enemynear,stateno != [5520,5550]
triggerall = enemynear,stateno != [5600,5650]
triggerall = enemynear,stateno != 3280
triggerall = enemynear,stateno != [120,155]
triggerall = !numhelper(1019)
triggerall = !numhelper(1029)
triggerall = ctrl || (stateno = [120,140])
trigger1 = P2bodydist X = [0,230] 
trigger1 = enemynear,pos Y = [-158,-70]
trigger1 = enemynear,vel Y > -1
trigger1 = enemynear,stateno = [5020,5050]
trigger1 = random = [700,899]
trigger1 = !numhelper(651)
trigger2 = P2bodydist X = [0,150]
trigger2 = enemynear,Pos Y > -128
trigger2 = helper(451),movehit
trigger3 = var(18) = 0 && !numhelper(1845)
trigger3 = P2bodydist X = [125,200]
trigger3 = enemynear,Pos Y > -128
trigger3 = enemynear,movetype = A
trigger3 = enemynear,time <= 12
trigger3 = enemynear,stateno != 200 && enemynear,stateno != 230 && enemynear,stateno != 400 && enemynear,stateno != 430 && enemynear,stateno != 600 && enemynear,stateno != 630 && (enemynear,stateno != [800,899])
trigger4 = var(18) = 0 && !numhelper(1845)
trigger4 = P2bodydist X = [160,270]
trigger4 = enemynear,vel X > 4
trigger4 = random = [700,899]
trigger4 = enemynear,stateno != [100,110]
trigger4 = enemynear,anim != 100

;---------------------------------------------------------------------------
;220 => Fake Gamma Charge
[State -1, 220 => Fake Gamma Charge]
type = ChangeState
value = ifelse(Life<=Lifemax/2,3100,1000)
triggerall = RoundState = 2 && var(59)
triggerall = StateType != A
triggerall = enemynear,statetype != L
triggerall = enemynear,stateno != [5100,5120]
triggerall = enemynear,anim!=5120
triggerall = power >= 1000
triggerall = enemynear,stateno != [120,155]
trigger1 = stateno = 220 && movehit
trigger1 = animtime >= -40
trigger1 = enemynear,Pos Y > -128
trigger1 = enemynear,movetype = H
trigger1 = enemynear,statetype != A

;---------------------------------------------------------------------------
;Crouch_A (Crouch Low Kick)
[State -1, 430]
type = ChangeState
value = 430
triggerall = RoundState = 2 && var(59)
triggerall = StateType != A
triggerall = enemynear,statetype != L
triggerall = enemynear,stateno != [5100,5120]
triggerall = enemynear,anim!=5120
triggerall = enemynear,statetype != A
triggerall = P2bodydist X = [-1,35]
trigger1 = !var(11) ;!var(55)
trigger1 = ctrl || stateno = 101

;---------------------------------------------------------------------------
;420 (Tongue) \
[State -1, 420]
type = ChangeState
value = 420
triggerall = RoundState = 2 && var(59)
triggerall = StateType != A
triggerall = enemynear,statetype = A
triggerall = enemynear,stateno != [5100,5120]
triggerall = enemynear,anim!=5120
triggerall = P2bodydist X = [10,35] ;[-1,35]
triggerall = enemynear,stateno != [5520,5550]
triggerall = enemynear,stateno != [5030,5050]
triggerall = enemynear,stateno != [5600,5650]
triggerall = enemynear,stateno != 5820
triggerall = !numhelper(1019)
triggerall = random < 100 ;@
trigger1 = ctrl || stateno = 101
trigger1 = enemynear,Pos Y = [-147,-50] ; -95,... / > -42
trigger1 = enemynear,vel Y > -1
trigger1 = !numhelper(651)

;---------------------------------------------------------------------------
;Stand_B (Spring)
[State -1, Stand_B]
type = ChangeState
value = 240
triggerall = RoundState = 2 && var(59)
triggerall = StateType != A
triggerall = enemynear,statetype != L
triggerall = enemynear,stateno != [5100,5120]
triggerall = enemynear,anim!=5120
triggerall = P2bodydist X = [-1,35] ;[35,45]
trigger1 = !numhelper(651) && !var(21) || numhelper(651) > 1 && helper(451),movehit >= 1 && (enemynear,stateno = [5020,5050])
trigger1 = !var(6)
trigger1 = enemynear,statetype = A
trigger1 = enemynear,movetype = H
trigger1 = ctrl
trigger1 = enemynear,Pos Y > -166
trigger1 = enemynear,vel Y > -1 

;---------------------------------------------------------------------------
;Stand_B (Spring) (ALt)
[State -1, Stand_B]
type = ChangeState
value = ifelse(Life<=Lifemax/2,240,220)
triggerall = RoundState = 2 && var(59)
triggerall = StateType != A
triggerall = enemynear,statetype != L
triggerall = enemynear,stateno != [5100,5120]
triggerall = enemynear,anim!=5120
triggerall = P2bodydist X = [-1,35] ;[35,45]
trigger1 = stateno = 430 && movehit

;---------------------------------------------------------------------------
;440, Ground Combo Launcher \
[State -1, 440, Ground Combo Launcher]
type = ChangeState
value = 440
triggerall = RoundState = 2 && var(59)
triggerall = StateType != A
triggerall = enemynear,statetype != L
triggerall = enemynear,stateno != [5100,5120]
triggerall = enemynear,anim!=5120
triggerall = ctrl || stateno = 101
triggerall = enemynear,movetype != H || enemynear,stateno = [150,151]
triggerall = enemynear,statetype != C
trigger1 = P2bodydist X = [90,120] ; [90,110]
trigger1 = enemynear,pos Y > -57
trigger1 = enemynear,vel Y > -1
trigger1 = random = [100,199]

;---------------------------------------------------------------------------
;220 (Tommy Gun, Combo)
[State -1, 220 (Tommy Gun, Combo)]
type = ChangeState
value = 220
triggerall = RoundState = 2 && var(59)
triggerall = StateType != A
triggerall = enemynear,statetype != L
triggerall = enemynear,stateno != [5100,5120]
triggerall = enemynear,anim!=5120
trigger1 = stateno = 240
trigger1 = moveguarded
trigger1 = enemynear,stateno = [150,155]
trigger2 = ctrl || stateno = 102 && time >= 15
trigger2 = P2bodydist X = [36,88];<= 88 ;[70,88]
trigger2 = enemynear,Pos Y > -108
trigger2 = enemynear,vel Y > -1
trigger2 = random = [770,849]
trigger2 = !numhelper(651)
trigger3 = stateno = 210
trigger3 = movehit
trigger3 = P2bodydist X = [120,140]

;trigger4 = stateno = 420 && moveguarded
;trigger4 = enemynear,stateno = [150,155]

;trigger4 = stateno = 410 || stateno = 430
;trigger4 = numhelper(15410) > 0 || numhelper(15430) > 0
;trigger4 = P2bodydist X = [0,90]
;trigger4 = enemynear,stateno != [150,155] ;Pausetime Cancelled by GardPush #
;trigger4 = helper(15410),parentdist X < 0 || helper(15430),parentdist X < 0 ;vel X < 0

;---------------------------------------------------------------------------
;Crouch_Y (Chainsaw)
[State -1, Crouch_Y]
type = ChangeState
value = 410
triggerall = RoundState = 2 && var(59)
triggerall = StateType != A
triggerall = enemynear,statetype != L
triggerall = enemynear,stateno != [5100,5120]
triggerall = enemynear,anim!=5120
trigger1 = P2bodydist X = [-1,84]
trigger1 = stateno = 430 && moveguarded

;---------------------------------------------------------------------------
;Overhead Attack
[State -1, Overhead Attack]
type = ChangeState
value = ifelse(Life<=Lifemax/2,270,220) ;260
triggerall = RoundState = 2 && var(59)
triggerall = StateType != A
triggerall = enemynear,statetype != L
triggerall = enemynear,stateno != [5100,5120]
triggerall = enemynear,anim!=5120
triggerall = P2bodydist X = [-1,120]
trigger1 = stateno = 440 && moveguarded
trigger1 = animtime >= -17
trigger1 = enemynear,statetype != A
trigger1 = enemynear,stateno = [120,155]
;trigger1 = enemynear,Pos Y > -84
;trigger1 = enemynear,vel Y > -1

;---------------------------------------------------------------------------
;260 Failed
[State -1, 260 Failed]
type = ChangeState
value = 627
triggerall = var(59)
Triggerall = (RoundState = 2)
Triggerall = StateType != L
triggerall = enemynear,statetype != L
triggerall = enemynear,stateno != [5100,5120]
triggerall = enemynear,anim!=5120
triggerall = statetype != A
trigger1 = stateno = [271,273]
trigger1 = animtime = -1
trigger1 = enemynear,stateno = [150,155]

;---------------------------------------------------------------------------
;Stand_Y (Bat)
[State -1, Stand_Y]
type = ChangeState
value = 210
triggerall = RoundState = 2 && var(59)
triggerall = StateType != A
triggerall = enemynear,statetype != L
triggerall = enemynear,stateno != [5100,5120]
triggerall = enemynear,anim!=5120
trigger1 = P2bodydist X = [36,88];[46,88]
trigger1 = !var(11) ;!var(55)
trigger1 = ctrl
trigger1 = enemynear,Pos Y > -93
trigger1 = enemynear,vel Y > -1
trigger1 = random = [600,769]
trigger1 = !numhelper(651)

;---------------------------------------------------------------------------
;10250 (Hammer, EX)
[State -1, 10250]
type = ChangeState
value = 256 ;10250 @
triggerall = RoundState = 2 && var(59)
triggerall = StateType != A
triggerall = enemynear,statetype != L
triggerall = enemynear,stateno != [5100,5120]
triggerall = enemynear,anim!=5120
trigger1 = ctrl
trigger1 = P2bodydist X = [89,130]
trigger1 = enemynear,Pos Y > -135
trigger1 = enemynear,vel Y > -1
trigger1 = random = [850,999]
trigger1 = enemynear,vel X > -4 && enemynear,vel X < 4 || (enemynear,stateno = [0,105])
trigger1 = !var(11)

;triggerall = enemynear,stateno != [130,155]

;---------------------------------------------------------------------------
;250 (Hammer)
[State -1, 250]
type = ChangeState
value = 256
triggerall = RoundState = 2 && var(59)
triggerall = StateType != A
triggerall = enemynear,statetype != L
triggerall = enemynear,stateno != [5100,5120]
triggerall = enemynear,anim!=5120
triggerall = enemynear,stateno != [130,155]
trigger1 = stateno = 210
trigger1 = movehit
trigger1 = P2bodydist X = [0,120]
trigger2 = stateno = 210 && moveguarded
trigger2 = enemynear,Pos Y < -37
trigger2 = enemynear,statetype != C 
trigger3 = stateno = 211 && movecontact

;---------------------------------------------------------------------------
;Jump => 620
[State -1, 625]
type = ChangeState
value = 625
triggerall = RoundState = 2 && var(59)
triggerall = StateType != A
triggerall = enemynear,statetype != L
triggerall = enemynear,stateno != [5100,5120]
triggerall = enemynear,anim!=5120
triggerall = P2bodydist X = [80,170]
triggerall = enemynear,pos Y > -50
triggerall = enemynear,vel Y > -1
triggerall = !var(11) ;!var(55)
trigger1 = ctrl
trigger1 = random = [250,324]
trigger2 = stateno = 101
trigger2 = random = [250,299]
trigger2 = enemynear,movetype != H || (enemynear,stateno = [150,155])

;---------------------------------------------------------------------------
;Super Jump Up -> Air Combo
[State -1, Super Jump Up -> Air Combo]
type = ChangeState
value = 60
triggerall = RoundState = 2 && var(59)
triggerall = StateType != A
triggerall = enemynear,vel Y < 0
trigger1 = stateno = 240 && movehit
trigger2 = stateno = 246 && movehit

;---------------------------------------------------------------------------
;Stand Z (Tommy Gun)
[State -1, Stand Z (Tommy Gun)]
type = ChangeState
value = 220
triggerall = RoundState = 2 && var(59)
triggerall = StateType != A
triggerall = enemynear,statetype != L
triggerall = enemynear,stateno != [5100,5120]
triggerall = enemynear,anim!=5120
trigger1 = !numhelper(651)
trigger1 = !var(11) ;!var(55)
trigger1 = !var(6)
trigger1 = P2bodydist X = [89,130]
trigger1 = enemynear,Pos Y > -108
trigger1 = enemynear,vel Y > -1
trigger1 = ctrl
trigger1 = random < 100

;---------------------------------------------------------------------------
;Yojimbo Slash (Combo)
[State -1, Yojimbo Slash (Combo)]
type = ChangeState
value = 1250
triggerall = RoundState = 2 && var(59)
triggerall = StateType != A
triggerall = enemynear,statetype != L
triggerall = enemynear,stateno != [5100,5120]
triggerall = enemynear,anim!=5120
trigger1 = stateno = 220 && movecontact && animtime >= -40 ;36;42
trigger1 = P2bodydist X = [0,30]
trigger2 = stateno = 420 && movecontact
trigger2 = P2bodydist X = [0,65]

;trigger1 = stateno = 220 && movecontact && animtime >= -30 ;24
;trigger1 = P2bodydist X = [31,65]

;---------------------------------------------------------------------------
;220 => Magnum 2
[State -1, 220 => Magnum 2]
type = ChangeState
value = 1500
triggerall = RoundState = 2 && var(59)
triggerall = StateType != A
triggerall = enemynear,statetype != L
triggerall = enemynear,stateno != [5100,5120]
triggerall = enemynear,anim!=5120
triggerall = Life <= Lifemax/2
trigger1 = stateno = 220 && movecontact 
trigger1 = animtime >= -40
trigger1 = P2bodydist X = [90,150]
trigger1 = enemynear,pos Y >= -30

;---------------------------------------------------------------------------
;220 => Magnum 3
[State -1, 220 => Magnum 3]
type = ChangeState
value = 1510
triggerall = RoundState = 2 && var(59)
triggerall = StateType != A
triggerall = enemynear,statetype != L
triggerall = enemynear,stateno != [5100,5120]
triggerall = enemynear,anim!=5120
triggerall = Life <= Lifemax/2
trigger1 = stateno = 220 && movecontact 
trigger1 = animtime >= -40
trigger1 = P2bodydist X = [151,250]
trigger1 = enemynear,pos Y >= -30

;---------------------------------------------------------------------------
;450 Against Guard Push
[State -1, 450 Against Guard Push]
type = ChangeState
value = 450
triggerall = RoundState = 2 && var(59)
triggerall = StateType != A
triggerall = numhelper(451) < 2
triggerall = random < 50
trigger1 = stateno = 410 || stateno = 430
trigger1 = numhelper(15410) > 0 || numhelper(15430) > 0
trigger1 = (enemynear,stateno != [150,155]) || enemynear,numhelper > var(9) ;Pausetime Cancelled by GardPush #
trigger1 = helper(15410),parentdist X < 0 || helper(15430),parentdist X < 0
trigger2 = stateno = 256 || stateno = 255 || stateno = 10255
trigger2 = numhelper(15250) > 0 
trigger2 = (enemynear,stateno != [150,155]) || enemynear,numhelper > var(9) ;Pausetime Cancelled by GardPush
trigger2 = helper(15250),parentdist X > 0
trigger3 = stateno = 256 || stateno = 255 || stateno = 10255
trigger3 = moveguarded && animtime >= -20
trigger3 = enemynear,stateno = [150,155]
trigger4 = stateno = 420 && moveguarded || stateno = 220
trigger4 = numhelper(15420) > 0
trigger4 = (enemynear,stateno != [150,155]) || enemynear,numhelper > var(9) ;Pausetime Cancelled by GardPush
trigger4 = helper(15420),parentdist X < 0
trigger5 = stateno = 210 || stateno = 256 || stateno = 440
trigger5 = numhelper(15210) > 0 
trigger5 = (enemynear,stateno != [150,155]) || enemynear,numhelper > var(9) ;Pausetime Cancelled by GardPush
trigger5 = helper(15210),parentdist X < 0
trigger6 = stateno = 440 || (stateno = [270,273])
trigger6 = numhelper(15440) > 0 
trigger6 = (enemynear,stateno != [150,155]) || enemynear,numhelper > var(9) ;Pausetime Cancelled by GardPush
trigger6 = helper(15440),parentdist X < 0
trigger7 = stateno = 240 || stateno = 220
trigger7 = numhelper(15240) > 0 
trigger7 = (enemynear,stateno != [150,155]) || enemynear,numhelper > var(9) ;Pausetime Cancelled by GardPush
trigger7 = helper(151240),parentdist X < 0

;trigger10 = stateno = 1100 
;trigger10 = numhelper(15110) > 0 
;trigger10 = (enemynear,stateno != [150,155]) || enemynear,numhelper > var(9) ;Pausetime Cancelled by GardPush
;trigger10 = helper(15110),parentdist X < 0

;---------------------------------------------------------------------------
;Gunfire 1 (Combo)
[State -1, Gunfire 1 (Combo)]
type = ChangeState
value = 1000
triggerall = RoundState = 2 && var(59)
triggerall = StateType != A
triggerall = enemynear,statetype != L
triggerall = enemynear,stateno != [5100,5120]
triggerall = enemynear,anim!=5120
trigger1 = stateno = 220 && movecontact && animtime >= -40
trigger1 = P2bodydist X > 65
trigger2 = stateno = 256 || stateno = 10255
trigger2 = movehit && animtime >= -20
trigger2 = enemynear,pos Y > -100
trigger2 = enemynear,vel Y < 0
trigger2 = enemynear,movetype = H && (enemynear,stateno != [120,155])
trigger2 = P2bodydist X > 190;48
trigger3 = stateno = 210
trigger3 = movehit
trigger3 = P2bodydist X > 140

;---------------------------------------------------------------------------
;Gunfire 1 (Against GuardPush) @
[State -1, Gunfire 1 (Against GuardPush)]
type = ChangeState
value = 1000
triggerall = RoundState = 2 && var(59)
triggerall = StateType != A
triggerall = enemynear,statetype != L
triggerall = enemynear,stateno != [5100,5120]
triggerall = enemynear,anim!=5120
triggerall = random < 200
trigger1 = numhelper(451) >= 2
trigger1 = stateno = 410 || stateno = 430
trigger1 = numhelper(15410) > 0 || numhelper(15430) > 0
trigger1 = (enemynear,stateno != [150,155]) || enemynear,numhelper > var(9) ;Pausetime Cancelled by GardPush #
trigger1 = helper(15410),parentdist X < 0 || helper(15430),parentdist X < 0
trigger2 = numhelper(451) >= 2
trigger2 = stateno = 256 || stateno = 255 || stateno = 10255
trigger2 = numhelper(15250) > 0 
trigger2 = (enemynear,stateno != [150,155]) || enemynear,numhelper > var(9) ;Pausetime Cancelled by GardPush
trigger2 = helper(15250),parentdist X > 0
trigger2 = enemynear,statetype != C
trigger3 = numhelper(451) >= 2
trigger3 = stateno = 256 || stateno = 255 || stateno = 10255
trigger3 = moveguarded && animtime >= -20
trigger3 = enemynear,stateno = [150,155]
trigger3 = enemynear,statetype != C
trigger4 = numhelper(451) >= 2
trigger4 = stateno = 420 && moveguarded || stateno = 220
trigger4 = numhelper(15420) > 0
trigger4 = (enemynear,stateno != [150,155]) || enemynear,numhelper > var(9) ;Pausetime Cancelled by GardPush
trigger4 = helper(15420),parentdist X < 0
trigger5 = numhelper(451) >= 2
trigger5 = stateno = 210 || stateno = 256 || stateno = 440
trigger5 = numhelper(15210) > 0 
trigger5 = (enemynear,stateno != [150,155]) || enemynear,numhelper > var(9) ;Pausetime Cancelled by GardPush
trigger5 = helper(15210),parentdist X < 0
trigger6 = numhelper(451) >= 2
trigger6 = stateno = 440 || (stateno = [270,273])
trigger6 = numhelper(15440) > 0 
trigger6 = (enemynear,stateno != [150,155]) || enemynear,numhelper > var(9) ;Pausetime Cancelled by GardPush
trigger6 = helper(15440),parentdist X < 0
trigger7 = numhelper(451) >= 2
trigger7 = stateno = 240 || stateno = 220
trigger7 = numhelper(15240) > 0 
trigger7 = (enemynear,stateno != [150,155]) || enemynear,numhelper > var(9) ;Pausetime Cancelled by GardPush
trigger7 = helper(151240),parentdist X < 0

;---------------------------------------------------------------------------
;440 (SpikeShoe)
[State -1, 440 (SpikeShoe)]
type = ChangeState
value = 440
triggerall = RoundState = 2 && var(59)
triggerall = StateType != A
triggerall = enemynear,statetype != L
triggerall = enemynear,stateno != [5100,5120]
triggerall = enemynear,anim!=5120
triggerall = P2bodydist X = [-1,110]
trigger1 = stateno = 410 && movecontact && animtime >= -15
trigger2 = stateno = 210 && moveguarded
trigger2 = enemynear,Pos Y >= -37 && enemynear,statetype = A || enemynear,statetype = S

;trigger2 = (enemynear,stateno = [150,155])
;trigger2 = enemynear,statetype != C 

;---------------------------------------------------------------------------
;440 => 255
[State -1, 255 (Hummer)]
type = ChangeState
value = 255
triggerall = RoundState = 2 && var(59)
triggerall = StateType != A
triggerall = enemynear,statetype != L
triggerall = enemynear,stateno != [5100,5120]
triggerall = enemynear,anim!=5120
trigger1 = stateno = 440 && movehit
trigger1 = P2bodydist X = [0,140]

;---------------------------------------------------------------------------
;255 => Run Fwd
[State -1, 255 => Run Fwd]
type = ChangeState
value = 101
triggerall = RoundState = 2 && var(59)
triggerall = StateType != A
triggerall = enemynear,statetype != L
triggerall = enemynear,stateno != [5100,5120]
triggerall = enemynear,anim!=5120
triggerall = stateno = 255 && movehit && animtime = -1
trigger1 = facing*(helper(30000+(facing=-1)*10),pos x-pos x)<=245
trigger2 = -facing*(helper(30000+(facing=-1)*10),pos x-pos x)>=245

;---------------------------------------------------------------------------
;255 => 3100 or 1000
[State -1, 255 => 3100 or 1000]
type = ChangeState
value = 1000 ;ifelse(power>=1000,3100,1000)
triggerall = RoundState = 2 && var(59)
triggerall = StateType != A
triggerall = enemynear,statetype != L
triggerall = enemynear,stateno != [5100,5120]
triggerall = enemynear,anim!=5120
triggerall = stateno = 255 && movehit && animtime = -1
trigger1 = facing*(helper(30000+(facing=-1)*10),pos x-pos x)>245
trigger2 = -facing*(helper(30000+(facing=-1)*10),pos x-pos x)<245

;---------------------------------------------------------------------------
;Surprise! \
[State -1, Surprise!]
type = ChangeState
value = 11100 
triggerall = RoundState = 2 && var(59)
triggerall = StateType != A
triggerall = enemynear,statetype != L
triggerall = enemynear,stateno != [5100,5120]
triggerall = enemynear,anim!=5120
triggerall = enemynear,movetype != H
triggerall = enemynear,stateno != [130,155]
triggerall = enemynear,pos Y > -150
triggerall = enemynear,vel Y > -3
triggerall = ctrl
triggerall = random = [100,249];199]
triggerall = !var(11) ;!var(55)
trigger1 = P2bodydist X = [90,130];[110,130]
trigger1 = enemynear,vel X = [-3,3]
trigger1 = !inguarddist
trigger2 = P2bodydist X = [131,150]
trigger2 = enemynear,vel X = [-4.5,4.5]
trigger3 = P2bodydist X = [151,200]
trigger3 = enemynear,vel X > 4

;---------------------------------------------------------------------------
;Gunfire 1 \
[State -1, Gunfire 1]
type = ChangeState
value = 1000
triggerall = var(8) = 0
triggerall = enemynear,stateno != [150,153]
triggerall = RoundState = 2 && var(59)
triggerall = StateType != A
triggerall = enemynear,statetype != L
triggerall = enemynear,stateno != [5100,5120]
triggerall = enemynear,anim!=5120
triggerall = !var(11) ;!var(55)
triggerall = enemynear,Pos Y > -100
triggerall = enemynear,vel Y > -1
triggerall = ctrl
trigger1 = P2bodydist X = [140,200];> 140
trigger1 = random = [250,299]
trigger2 = P2bodydist X > 200
trigger2 = random = [200,299]

;---------------------------------------------------------------------------
;Gunfire 2
[State -1, Gunfire 2]
type = ChangeState
value = 1010
triggerall = RoundState = 2 && var(59)
triggerall = StateType != A
triggerall = enemynear,statetype != L
triggerall = enemynear,stateno != [5100,5120]
triggerall = enemynear,anim!=5120
triggerall = !numhelper(1019) 
trigger1 = enemynear,stateno != [150,153]
trigger1 = var(8) = 0
trigger1 = !var(11) ;!var(55)
trigger1 = P2bodydist X > 160
trigger1 = enemynear,Pos Y > -120
trigger1 = enemynear,vel Y > -1
trigger1 = ctrl
trigger1 = random = [300,399]
trigger2 = ctrl ;|| stateno = 0 && prevstateno = 103
trigger2 = enemynear,stateno = 5820
trigger2 = P2bodydist X > 130
trigger2 = enemynear,pos Y = [-700,-550] ;^
trigger3 = ctrl 
trigger3 = enemynear,stateno = 5820
trigger3 = P2bodydist X = [101,300] ;130] ;[87,130]
trigger3 = enemynear,pos Y = [-600,-500] ;[-650,-500]

;---------------------------------------------------------------------------
;Gunfire 3
[State -1, Gunfire 3]
type = ChangeState
value = 1020
triggerall = RoundState = 2 && var(59)
triggerall = StateType != A
triggerall = enemynear,statetype != L
triggerall = enemynear,stateno != [5100,5120]
triggerall = enemynear,anim!=5120
triggerall = numhelper(1024) < 2
triggerall = !numhelper(1024) || (numhelper(1024) = 1 && helper(1024),parentdist X < -112) || (numhelper(1024) = 1 && helper(1024),parentdist X > 57) ; 143 -83
trigger1 = P2bodydist X > 140
trigger1 = ctrl
trigger1 = random = [475,499] ;499]

;---------------------------------------------------------------------------
;Gunfire 3, Combo
[State -1, Gunfire 3, Combo]
type = ChangeState
value = 1020
triggerall = RoundState = 2 && var(59)
triggerall = StateType != A
triggerall = enemynear,statetype != L
triggerall = enemynear,stateno != [5100,5120]
triggerall = enemynear,anim!=5120
triggerall = numhelper(1024) < 2
trigger1 = stateno = 420 && movehit && animtime = -1
;trigger1 = stateno = 440 && movehit && animtime = -1

;---------------------------------------------------------------------------
;Crouch C (Bomb) \
[State -1, Crouch C (Bomb)]
type = ChangeState
value = 450
triggerall = RoundState = 2 && var(59)
triggerall = StateType != A
triggerall = numhelper(451) < 1
triggerall = enemynear,stateno != 5711 ;@
trigger1 = ctrl
trigger1 = (P2bodydist X = [141,170])
trigger1 = !inguarddist
trigger1 = random = [500,599]
trigger2 = P2bodydist X > 170
trigger2 = ctrl || stateno = 450 && animtime = -1 && !inguarddist
trigger2 = random = [500,599]
trigger3 = ctrl || stateno = 450 && animtime = -1 && !inguarddist
trigger3 = P2bodydist X > 140
trigger3 = var(8) = 1
trigger3 = (random = [200,399]) || (random = [600,699]) || (random = [500,599])
trigger4 = anim = 1001 && animtime = -1
trigger4 = P2bodydist X > 130
trigger4 = enemynear,stateno = [130,155]
trigger4 = !inguarddist
trigger4 = random >= 625
trigger5 = var(8) = 1 || enemynear,statetype = L
trigger5 = stateno = 8887
trigger5 = P2bodydist X > 125 || time >= 29
trigger5 = !inguarddist

;---------------------------------------------------------------------------
;Magnum 2
[State -1, Magnum 2]
type = ChangeState
value = 1500
triggerall = RoundState = 2 && var(59)
triggerall = StateType != A
triggerall = enemynear,statetype != L
triggerall = enemynear,stateno != [5100,5120]
triggerall = enemynear,anim!=5120
trigger1 = !var(11) ;!var(55)
trigger1 = ctrl
trigger1 = enemynear,statetype!= A
trigger1 = P2bodydist X = [140,180]
trigger1 = random = [600,749] ;699]
trigger1 = enemynear,stateno != [150,155]
trigger1 = enemynear,stateno != [130,132]
trigger2 = random < 200
trigger2 = numhelper(451) >= 2
trigger2 = stateno = 256 || stateno = 255 || stateno = 10255
trigger2 = numhelper(15250) > 0 
trigger2 = (enemynear,stateno != [150,155]) || enemynear,numhelper > var(9) ;Pausetime Cancelled by GardPush #
trigger2 = helper(15250),parentdist X < 0
trigger2 = enemynear,statetype = C
trigger2 = P2bodydist X = [0,150]
trigger3 = random < 200
trigger3 = numhelper(451) >= 2
trigger3 = stateno = 256 || stateno = 255 || stateno = 10255
trigger3 = moveguarded && animtime >= -20
trigger3 = enemynear,statetype = C
trigger3 = P2bodydist X = [0,150]
trigger4 = stateno = 440 && movehit
trigger4 = P2bodydist X > 140

;---------------------------------------------------------------------------
;Magnum 3
[State -1, Magnum 3]
type = ChangeState
value = 1510
triggerall = RoundState = 2 && var(59)
triggerall = StateType != A
triggerall = enemynear,statetype != L
triggerall = enemynear,stateno != [5100,5120]
triggerall = enemynear,anim!=5120
trigger1 = !var(11) ;!var(55)
trigger1 = ctrl
trigger1 = enemynear,statetype!= A
trigger1 = P2bodydist X = [198,280]
trigger1 = random = [600,749] ;699]
trigger1 = enemynear,stateno != [150,155]
trigger1 = enemynear,stateno != [130,132]
trigger2 = random < 200
trigger2 = numhelper(451) >= 2
trigger2 = stateno = 256 || stateno = 255 || stateno = 10255
trigger2 = numhelper(15250) > 0 
trigger2 = (enemynear,stateno != [150,155]) || enemynear,numhelper > var(9) ;Pausetime Cancelled by GardPush
trigger2 = helper(15250),parentdist X < 0
trigger2 = enemynear,statetype = C
trigger2 = P2bodydist X = [150,250]
trigger3 = random < 200
trigger3 = numhelper(451) >= 2
trigger3 = stateno = 256 || stateno = 255 || stateno = 10255
trigger3 = moveguarded && animtime >= -20
trigger3 = enemynear,statetype = C
trigger3 = P2bodydist X = [150,250]


;---------------------------------------------------------------------------
;Air Bomb
[State -1, Teleport Right]
type = ChangeState
value = 1400
triggerall = RoundState = 2 && var(59)
triggerall = StateType = A
trigger1 = !numhelper(651)
trigger1 = ctrl
trigger1 = P2bodydist X = [41,160]
trigger1 = Pos Y < -120
trigger1 = random < 100;75


;===========================================================================

;---------------------------------------------------------------------------
;Run Fwd \
;_bV
[State -1, Run Fwd]
type = ChangeState
value = 101
triggerall = RoundState = 2 && var(59)
triggerall = StateType != A
triggerall = enemynear,statetype != L
triggerall = enemynear,stateno != [5100,5120]
triggerall = enemynear,anim!=5120
triggerall = ctrl
triggerall = enemynear,stateno != 5820
triggerall = P2bodydist X > 35
triggerall = (enemynear,stateno != [5030,5050]) 
triggerall = !var(11) ;!var(55)
trigger1 = P2bodydist X <= 130
trigger1 = random = [750,849]
trigger2 = P2bodydist X > 130
trigger2 = random = [750,899]
trigger3 = var(8) = 1 ;\
trigger4 = anim = 1001 && animtime = -1
trigger4 = P2bodydist X > 130
trigger4 = enemynear,stateno = [130,155]
trigger4 = !inguarddist
trigger4 = random < 625
trigger5 = numhelper(451) > 0
trigger5 = P2bodydist X = [131,170]
trigger6 = numhelper(451) > 0 ;1
trigger6 = P2bodydist X > 170

;---------------------------------------------------------------------------
;Run Fwd 102
[State -1, Run 102]
type = ChangeState
value = 102
triggerall = RoundState = 2 && var(59)
triggerall = StateType != A
triggerall = enemynear,stateno != [5100,5120]
triggerall = enemynear,anim!=5120
triggerall = ctrl
triggerall = P2bodydist X > 150
triggerall = numhelper(451) >= 2
trigger1 = ctrl
trigger2 = stateno = 1000 && animtime = -1

;---------------------------------------------------------------------------
;Run Fwd
;_bV
[State -1, Run Fwd]
type = ChangeState
value = 101
triggerall = RoundState = 2 && var(59)
triggerall = StateType != A
triggerall = enemynear,statetype != L
triggerall = enemynear,stateno != [5100,5120]
triggerall = enemynear,anim!=5120
triggerall = ctrl
triggerall = enemynear,stateno != 5820
triggerall = P2bodydist X > 35
trigger1 = (enemynear,stateno = [5030,5050]) && enemynear,pos Y < -60
trigger1 = P2bodydist X = [35,230]

;---------------------------------------------------------------------------
;Run Fwd 
[State -1, Run Fwd, combo]
type = ChangeState
value = 101
triggerall = RoundState = 2 && var(59)
triggerall = StateType != A
triggerall = enemynear,statetype != L
triggerall = enemynear,stateno != [5100,5120]
triggerall = enemynear,anim!=5120
trigger1 = stateno = 256 || stateno = 10255
trigger1 = movehit && animtime = -1
trigger1 = (enemynear,stateno = [5600,5601]) || enemynear,movetype = H && (enemynear,stateno != [120,155])
trigger1 = P2bodydist X = [51,190] ;78] ;40,178] ;51,178]
trigger2 = enemynear,stateno = 5711 || (ProjhitTime(1019)>-1 && ProjhittIme(1019)<26)
trigger2 = anim = 1011 && animtime = -1 || ctrl
trigger2 = P2bodydist X = [25,145] ;51,145]
trigger2 = enemynear,movetype = H
trigger2 = enemynear,stateno != [120,155]
trigger3 = ctrl
trigger3 = enemynear,stateno = [5520,5550]
trigger3 = P2bodydist X >= 15 ;25 ;35;45
trigger4 = ctrl
trigger4 = enemynear,stateno = 5820
trigger4 = (P2bodydist X = [45,100]) || P2bodydist X > 300 ;87]
trigger5 = stateno = [271,273]
trigger5 = animtime = -1
trigger5 = (ProjhitTime(271)>-1 && ProjhittIme(271)<32) || (ProjhitTime(272)>-1 && ProjhittIme(272)<32) || (ProjhitTime(273)>-1 && ProjhittIme(273)<32)
trigger5 = enemynear,movetype = H
trigger5 = enemynear,stateno != [150,155]

;===========================================================================

;---------------------------------------------------------------------------
;Air_X
[State -1, Air_X]
type = ChangeState
value = 600
triggerall = RoundState = 2 && var(59)
triggerall = StateType = A
triggerall = P2bodydist X = [-10,40] ;(P2bodydist X = [-1,40]) && frontedgedist > 30 || (P2bodydist X = [-10,40]) && frontedgedist <= 30 
trigger1 = stateno = 61 ;|| stateno = 948 || stateno = 600 && animtime = -1 && enemynear,movetype = H
trigger1 = ((enemynear,pos Y)-pos Y) = [-65,50] ;[-80,50]
trigger2 = !numhelper(651)
trigger2 = P2bodydist Y = [-10,10]
trigger2 = ctrl
trigger2 = prevstateno != 1600

;---------------------------------------------------------------------------
;Weight Smash
[State -1, Weight Smash, Single]
type = ChangeState
value = 1600
triggerall = RoundState = 2 && var(59)
triggerall = StateType = A
triggerall = enemynear,stateno != [5100,5110]
triggerall = enemynear,anim != [5100,5110]
triggerall = Pos Y - enemynear,pos Y < -180 && (enemynear,movetype != H || (enemynear,stateno = [152,153]) || (enemynear,stateno = 131) ) || Pos Y - enemynear,pos Y < -70 && enemynear,movetype = H && (enemynear,stateno != [150,155])
triggerall = ctrl
triggerall = P2bodydist X = [-17,25]
triggerall = enemynear,vel X = [-3,3]
trigger1 = helper(1024),movehit && random < 1
trigger2 = helper(451),movehit && random < 1
trigger3 = helper(1027),movehit && random < 1
trigger4 = enemynear,stateno != [200,650]
trigger4 = random = [200,399]
trigger5 = enemynear,stateno = [200,650]
trigger5 = enemynear,time <= 7
trigger5 = random = [200,449]

;---------------------------------------------------------------------------
;Air_Z
[State -1, Air_Z]
type = ChangeState
value = 620
triggerall = RoundState = 2 && var(59)
triggerall = StateType = A
trigger1 = !numhelper(651)
trigger1 = ctrl
trigger1 = P2bodydist X = [0,100]
trigger1 = P2bodydist Y = [0,93]
trigger1 = random = [100,199]
trigger1 = prevstateno != 1600 

;---------------------------------------------------------------------------
;Air_A
[State -1, Air_A]
type = ChangeState
value = 630
triggerall = RoundState = 2 && var(59)
triggerall = StateType = A
trigger1 = stateno = 600 && movecontact

;---------------------------------------------------------------------------
;Air_B
[State -1, Air_B]
type = ChangeState
value = 640
triggerall = RoundState = 2 && var(59)
triggerall = StateType = A
trigger1 = stateno = 610 && movecontact

;---------------------------------------------------------------------------
;Air_Y
[State -1, Air_Y]
type = ChangeState
value = 610
triggerall = RoundState = 2 && var(59)
triggerall = StateType = A
trigger1 = stateno = 630 && movecontact

;---------------------------------------------------------------------------
;Air_C
[State -1, Air_C]
type = ChangeState
value = 650
triggerall = RoundState = 2 && var(59)
triggerall = StateType = A
triggerall = stateno = 640 && movecontact
trigger1 = facing*(helper(30000+(facing=-1)*10),pos x-pos x)<=220
trigger2 = -facing*(helper(30000+(facing=-1)*10),pos x-pos x)>=220

;---------------------------------------------------------------------------
;Weight Smash
[State -1, Weight Smash, Combo]
type = ChangeState
value = 1600
triggerall = RoundState = 2 && var(59)
triggerall = StateType = A
triggerall = stateno = 640 && movecontact
trigger1 = facing*(helper(30000+(facing=-1)*10),pos x-pos x)>220
trigger2 = -facing*(helper(30000+(facing=-1)*10),pos x-pos x)<220

;------------------------------------------------------------------------------
;Recover Rolls


[state -1, recover F 1]
type = changestate
value = 890
triggerall = var(59) 
triggerall = RoundState = 2
TriggerAll = alive 
Triggerall = stateno = 5120
trigger1 = P2bodydist X = [100,140]
trigger2 = P2bodydist X = [200,250]
trigger3 = inguarddist || enemynear,numproj > 0
trigger3 = frontedgedist > 50
trigger4 = P2bodydist X = [141,199]
trigger4 = enemynear,vel X >= 3
trigger4 = Backedgedist <= 50

[state -1, recover B 1]
type = changestate
value = 895
triggerall = var(59) 
triggerall = RoundState = 2
TriggerAll = alive 
Triggerall = stateno = 5120
trigger1 = P2bodydist X = [-140,-120]
trigger2 = P2bodydist X = [-250,-200]
trigger3 = inguarddist || enemynear,numproj > 0
trigger3 = frontedgedist <= 50
trigger4 = P2bodydist X = [141,199]
trigger4 = enemynear,vel X >= 3
trigger4 = Backedgedist > 50


[state -1, recover F 1]
type = null;changestate
value = 890
triggerall = var(59) 
triggerall = RoundState = 2
TriggerAll = alive 
Triggerall = stateno = 5120
triggerall = backedgedist <= 40
triggerall = enemynear,facing != facing
trigger1 = P2bodydist x = [-10,50]
trigger2 = inguarddist
trigger2 = P2bodydist x > 150
trigger3 = enemynear,numproj > 0
trigger3 = P2bodydist x > 150

[state -1, recover F 2]
type = null;changestate
value = 890
triggerall = var(59) 
triggerall = RoundState = 2
TriggerAll = alive 
Triggerall = stateno = 5120
triggerall = frontedgedist >= 40
triggerall = enemynear,facing = facing
trigger1 =  P2bodydist x = [-70,10]
trigger2 = inguarddist 
trigger3 = enemynear,numproj > 0

[state -1, recover B 1]
type = null;changestate
value = 895
triggerall = var(59) 
triggerall = RoundState = 2
TriggerAll = alive 
Triggerall = stateno = 5120
triggerall = backedgedist > 40
triggerall = enemynear,facing != facing
trigger1 =  P2bodydist x = [-10,70]
trigger2 = inguarddist 
trigger3 = enemynear,numproj > 0

[state -1, recover B 2]
type = null;changestate
value = 895
triggerall = var(59) 
triggerall = RoundState = 2
TriggerAll = alive 
Triggerall = stateno = 5120
triggerall = frontedgedist >= 40
triggerall = enemynear,facing = facing
trigger1 = P2bodydist x = [-50,10]
trigger2 = inguarddist
trigger2 = P2bodydist x >= -150
trigger3 = enemynear,numproj > 0
trigger3 = P2bodydist x >= -150

;-----------------------------------------------------------------------------------
; Air Recovers

[state -1, Air recovers]
type = changestate
value = 5040
triggerall = var(59) 
triggerall = RoundState = 2
triggerall = statetype = L
Triggerall = alive && canrecover
trigger1 = stateno = [5030,5035]
trigger2 = stateno = [5050,5035]

[state -1, Air recovers]
type = changestate
value = 5200
triggerall = var(59) 
triggerall = RoundState = 2
triggerall = statetype = L
Trigger1 = alive && canrecover
trigger1 = stateno = 5050

[state -1, Air recovers]
type = changestate
value = 5200
triggerall = var(59) 
triggerall = RoundState = 2
triggerall = statetype = L
Trigger1 = alive && canrecover
trigger1 = stateno = 5210


;---------------------------------------------------------------------------------
; Combo Breaker
[State -1, Combo Breaker test]
type = null;ChangeState
value = 3895
triggerall = !Var(59)
trigger1 = command = "s"

;---------------------------------------------------------------------------------
; Combo Breaker
[State -1, Combo Breaker]
type = null;ChangeState
value = 3890
triggerall = Var(59)
triggerall = var(56) >= 1000
triggerall = movetype = H && alive 
triggerall = stateno != [120,155]
triggerall = stateno != [464,484]
triggerall = stateno != [5800,5831]
triggerall = stateno != 5401
triggerall = var(58) > 0
triggerall = anim != [5101,5120]
triggerall = stateno != [5100,5120]
trigger1 = P2bodydist X > 60 || P2bodydist X < -60
trigger1 = enemynear,hitdefattr = SCA,HA,HT,HP || enemynear,stateno >= 3000 && enemynear,movetype != H && enemynear,stateno != [5000,5999]
trigger1 = var(58) > 1 && var(49) >= 2 || var(49) = 11
trigger1 = gethitvar(hitcount) > 3
trigger2 = life <= 200 ;150
trigger2 = enemynear,hitdefattr = SCA,AA
trigger3 = life <= 200
trigger3 = !(enemynear,hitdefattr = SCA,AA,AT)
trigger3 = gethitvar(hitcount) > 0
trigger4 = Gethitvar(Damage) >= 300
trigger5 = P2bodydist x = [-60,60]
trigger5 = P2bodydist y = [-140,60]
trigger5 = gethitvar(damage) >= 120
trigger5 = life <= 500
ignorehitpause = 1

;---------------------------------------------------------------------------------
; Combo Breaker
[State -1, Combo Breaker]
type = ChangeState
value = 3890
triggerall = Var(59)
triggerall = var(56) >= 1000
triggerall = movetype = H && alive 
triggerall = P2bodydist x = [-60,60]
triggerall = P2bodydist y = [-140,60]
triggerall = stateno != [120,155]
triggerall = stateno != [464,484]
triggerall = stateno != [5800,5831]
triggerall = stateno != 5401
triggerall = anim != [5101,5120]
triggerall = stateno != [5100,5120]
triggerall = var(58) > 0   ;trigger1 = enemynear,hitdefattr = SCA,AA,AT
triggerall = !(enemynear,hitdefattr = SCA,AT)
trigger1 = var(15) = 0
trigger1 = gethitvar(hitcount) > 3
trigger1 = life <= 500
ignorehitpause = 1
;trigger1 = gethitvar(hitcount) >= 1



;===========================================================================
;                                 MANUAL
;---------------------------------------------------------------------------

;---------------------------------------------------------------------------
;Combo Breaker
[State -1, Combo Breaker]
type = ChangeState
value = 3890
triggerall = !var(59)
triggerall = var(56) >= 1000
triggerall = movetype = H && alive 
triggerall = stateno != [120,155]
triggerall = stateno != [464,484]
triggerall = stateno != [5800,5831]
triggerall = stateno != 5401
triggerall = stateno != 5040
triggerall = stateno != [5200,5201]
triggerall = anim != [5101,5120]
triggerall = stateno != [5100,5120]
triggerall = var(58) > 0 
trigger1 = command = "Breaker"

;---------------------------------------------------------------------------
;Bullet Fury
[State -1, Bullet Fury]
type = ChangeState
value = 3000
triggerall = !var(59)
triggerall = command = "TripleKFPalm"
triggerall = power >= 1000
triggerall = !numhelper(3154)
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = statetype != A
trigger2 = hitdefattr = SC, NA, SA, HA
trigger2 = stateno != [3000,3200]
trigger2 = movecontact
trigger3 = stateno = 220 && movecontact && animtime >= -40

;---------------------------------------------------------------------------
;Fake Gamma Charge
[State -1, Fake Gamma Charge]
type = ChangeState
value = 3100
triggerall = !var(59)
triggerall = command = "QCF_ab"
triggerall = power >= 1000
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = statetype != A
trigger2 = hitdefattr = SC, NA, SA, HA
trigger2 = stateno != [3000,3200]
trigger2 = movecontact
trigger3 = stateno = 220 && movecontact && animtime >= -40

;---------------------------------------------------------------------------
;Suicide Bombing
[State -1, Suicide Bombing]
type = ChangeState
value = 3200
triggerall = !var(59)
triggerall = command = "Suicide Bombing"
triggerall = power >= 1000
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = statetype != A
trigger2 = hitdefattr = SC, NA, SA, HA
trigger2 = stateno != [3000,3200]
trigger2 = movecontact

;---------------------------------------------------------------------------
;Yojimbo Slash
[State -1, Yojimbo Slash]
type = ChangeState
value = 1200
triggerall = !var(59)
triggerall = command = "Yojimbo Slash"
trigger1 = ctrl = 1
trigger1 = statetype = S

;---------------------------------------------------------------------------
;Yojimbo Slash
[State -1, Yojimbo Slash]
type = ChangeState
value = 1250
triggerall = !var(59)
triggerall = command = "Yojimbo Slash"
triggerall = statetype != A
trigger1 = stateno = 200 && movecontact
trigger2 = stateno = 420 && movecontact
trigger3 = stateno = 210 && movecontact
trigger4 = stateno = 400 && movecontact
trigger5 = stateno = 410 && movecontact
trigger6 = stateno = 230 && movecontact
trigger7 = stateno = 220 && movecontact && animtime >= -40
trigger8 = stateno = 250 && movecontact ;&& animtime >= -20
trigger9 = stateno = 220
trigger9 = moveguarded 
trigger9 = enemynear,stateno != [150,155] ;Pausetime Cancelled by GardPush

;---------------------------------------------------------------------------
;Gunfire 1
[State -1, Gunfire 1]
type = ChangeState
value = 1000
triggerall = !var(59)
triggerall = command = "QCF_x"
trigger1 = ctrl = 1
trigger1 = statetype = S
trigger2 = stateno = 200 && movecontact
trigger3 = stateno = 210 && movecontact
trigger4 = stateno = 400 && movecontact
trigger5 = stateno = 410 && movecontact
trigger6 = stateno = 230 && movecontact
trigger7 = stateno = 220 && movecontact && animtime >= -40
trigger8 = stateno = 250 && movecontact
trigger9 = stateno = 220
trigger9 = moveguarded 
trigger9 = enemynear,stateno != [150,155] ;Pausetime Cancelled by GardPush

;---------------------------------------------------------------------------
;Gunfire 2
[State -1, Gunfire 2]
type = ChangeState
value = 1010
triggerall = !var(59)
triggerall = command = "QCF_y"
trigger1 = ctrl = 1
trigger1 = statetype = S

;---------------------------------------------------------------------------
;Gunfire 3
[State -1, Gunfire 3]
type = ChangeState
value = 1020
triggerall = !var(59)
triggerall = command = "QCF_z"
trigger1 = ctrl = 1
trigger1 = statetype = S
trigger2 = stateno = 420 && animtime = -1

;---------------------------------------------------------------------------
;Surprise!
[State -1, Surprise!]
type = ChangeState
value = 1100
triggerall = !var(59)
triggerall = command = "Surprise!"
trigger1 = ctrl = 1
trigger1 = statetype = S

;---------------------------------------------------------------------------
;Surprise!
[State -1, Surprise!]
type = ChangeState
value = 280
triggerall = !var(59)
triggerall = command = "Surprise!"
trigger1 = stateno = [200,210]
trigger1 = movecontact
trigger2 = stateno = [230,240]
trigger2 = movecontact
trigger3 = stateno = 220 && movecontact && time >= 26
trigger4 = stateno = 250 && movecontact

;---------------------------------------------------------------------------
;Teleport Left
[State -1, Teleport Left]
type = ChangeState
value = 1300
triggerall = !var(59)
triggerall = command = "Teleport Left"
trigger1 = ctrl = 1
trigger1 = statetype = S

;---------------------------------------------------------------------------
;Teleport Med
[State -1, Teleport Med]
type = ChangeState
value = 1310
triggerall = !var(59)
triggerall = command = "Teleport Med"
trigger1 = ctrl = 1
trigger1 = statetype = S

;---------------------------------------------------------------------------
;Teleport Right
[State -1, Teleport Right]
type = ChangeState
value = 1320
triggerall = !var(59)
triggerall = command = "Teleport Right"
trigger1 = ctrl = 1
trigger1 = statetype = S

;---------------------------------------------------------------------------
;Air Bomb
[State -1, Teleport Right]
type = ChangeState
value = 1400
triggerall = !var(59)
triggerall = command = "Air Bomb"
trigger1 = ctrl = 1
trigger1 = statetype = A

;---------------------------------------------------------------------------
;Air Bomb
[State -1, Teleport Right]
type = ChangeState
value = 1400
triggerall = !var(59)
triggerall = command = "Air Bomb"
trigger1 = ctrl = 1
trigger1 = statetype = A

;---------------------------------------------------------------------------
;Weight Smash
[State -1, Weight Smash]
type = ChangeState
value = 1600
triggerall = !var(59)
triggerall = command = "Teleport Right" || command = "Teleport Med" || command = "Teleport Left"
triggerall = statetype = A
trigger1 = ctrl = 1
trigger2 = stateno = 600 && movecontact
trigger3 = stateno = 630 && movecontact
trigger4 = stateno = 610 && movecontact
trigger5 = stateno = 640 && movecontact

;---------------------------------------------------------------------------
;Magnum 1 (Overhead Attack)
[State -1, Magnum 1]
type = ChangeState
value = 260
triggerall = !var(59)
triggerall = command = "Magnum 1"
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = stateno = 440 && movecontact && animtime >= -17

;---------------------------------------------------------------------------
;Magnum 2
[State -1, Magnum 2]
type = ChangeState
value = 1500
triggerall = !var(59)
triggerall = command = "Magnum 2"
trigger1 = ctrl = 1
trigger1 = statetype = S
trigger2 = stateno = 200 && movecontact
trigger3 = stateno = 210 && movecontact
trigger4 = stateno = 400 && movecontact
trigger5 = stateno = 410 && movecontact
trigger6 = stateno = 230 && movecontact
trigger7 = stateno = 220 && movecontact && animtime >= -40
trigger8 = stateno = 250 && movecontact
trigger9 = stateno = 220
trigger9 = moveguarded 
trigger9 = enemynear,stateno != [150,155] ;Pausetime Cancelled by GardPush

;---------------------------------------------------------------------------
;Magnum 3
[State -1, Magnum 3]
type = ChangeState
value = 1510
triggerall = !var(59)
triggerall = command = "Magnum 3"
trigger1 = ctrl = 1
trigger1 = statetype = S
trigger2 = stateno = 200 && movecontact
trigger3 = stateno = 210 && movecontact
trigger4 = stateno = 400 && movecontact
trigger5 = stateno = 410 && movecontact
trigger6 = stateno = 230 && movecontact
trigger7 = stateno = 220 && movecontact && animtime >= -40
trigger8 = stateno = 250 && movecontact
trigger9 = stateno = 220
trigger9 = moveguarded 
trigger9 = enemynear,stateno != [150,155] ;Pausetime Cancelled by GardPush


;===========================================================================
;---------------------------------------------------------------------------
;Run Fwd
;_bV
[State -1, Run Fwd]
type = ChangeState
value = 100
triggerall = !var(59)
trigger1 = command = "FF"
trigger1 = statetype = S
trigger1 = ctrl

;---------------------------------------------------------------------------
;Run Back
;ރ_bV
[State -1, Run Back]
type = ChangeState
value = 105
triggerall = !var(59)
trigger1 = command = "BB"
trigger1 = statetype = S
trigger1 = ctrl

;---------------------------------------------------------------------------
;Guard Push_G (Near)
[State -1, Guard Push_G]
type = ChangeState
value = 465
triggerall = !var(59)
triggerall = statetype != A
triggerall = (stateno = [150,155]) ;&& ctrl = 0
trigger1 = command = "GuardPush1"
ignorehitpause = 1

;---------------------------------------------------------------------------
;Guard Push_G (Far)
[State -1, Guard Push_G]
type = ChangeState
value = 466
triggerall = !var(59)
triggerall = statetype != A
triggerall = (stateno = [150,155]) ;&& ctrl = 0
trigger1 = command = "GuardPush2"
ignorehitpause = 1

;---------------------------------------------------------------------------
;Guard Push_A
[State -1, Guard Push_A]
type = ChangeState
value = 474
triggerall = !var(59)
triggerall = statetype = A
triggerall = (stateno = [150,155]) ;&& ctrl = 0
trigger1 = command = "GuardPush1"
trigger2 = command = "GuardPush2"
ignorehitpause = 1

;===========================================================================
;---------------------------------------------------------------------------
[State -1, Throw]
type = ChangeState
triggerall = !var(59)
triggerall = (command = "z")
triggerall = (StateNo != 100)
trigger1 = (command = "holdfwd") || (command = "holdback")
trigger1 = (StateType != A)
trigger1 = (Ctrl)
trigger1 = (P2BodyDist X < 8)
trigger1 = (P2StateType != A)
trigger1 = (P2MoveType != H)
value = 800

;---------------------------------------------------------------------------
;Stand_X
[State -1, Stand_X]
type = ChangeState
value = 200
triggerall = !var(59)
triggerall = command = "x"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl

;---------------------------------------------------------------------------
;Stand_Y
[State -1, Stand_Y]
type = ChangeState
value = 210
triggerall = !var(59)
triggerall = command = "y"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = stateno = 200
trigger2 = movecontact
trigger3 = stateno = 230
trigger3 = movecontact
;trigger4 = stateno = 400 && movecontact

;---------------------------------------------------------------------------
;Stand_Z
[State -1, Stand_Z]
type = ChangeState
value = 220
triggerall = !var(59)
triggerall = command = "z"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = stateno = [200,210]
trigger2 = movecontact
trigger3 = stateno = 410 || stateno = 400 || stateno = 430 || stateno = 240
trigger3 = movecontact

;---------------------------------------------------------------------------
;Stand_A
[State -1, Stand_A]
type = ChangeState
value = 230
triggerall = !var(59)
triggerall = command = "a"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = stateno = 200
trigger2 = movecontact

;---------------------------------------------------------------------------
;Stand_B
[State -1, Stand_B]
type = ChangeState
value = 240
triggerall = !var(59)
triggerall = command = "b"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = stateno = 200 || stateno = 210 || stateno = 230 || stateno = 400 || stateno = 410 || stateno = 430
trigger2 = movecontact

;---------------------------------------------------------------------------
;Stand_C
[State -1, Stand_C]
type = ChangeState
value = 250
triggerall = !var(59)
triggerall = command = "c"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl 
trigger2 = (stateno = [200,210]) || stateno = 230 || stateno = 430
trigger2 = movecontact

;---------------------------------------------------------------------------
;440 => 255
[State -1, 255 (Hummer)]
type = ChangeState
value = 255
triggerall = !var(59)
triggerall = command = "c"
triggerall = command != "holddown"
trigger1 = stateno = 440 && movecontact

;---------------------------------------------------------------------------
;Crouch_X
[State -1, Crouch_X]
type = ChangeState
value = 400
triggerall = !var(59)
triggerall = command = "x"
triggerall = command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl
trigger2 = stateno = 200
trigger2 = movecontact
trigger3 = stateno = 230
trigger3 = movecontact

;---------------------------------------------------------------------------
;Crouch_Y
[State -1, Crouch_Y]
type = ChangeState
value = 410
triggerall = !var(59)
triggerall = command = "y"
triggerall = command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl
trigger2 = stateno = 400 && movecontact
trigger3 = stateno = 430 && movecontact
trigger4 = stateno = 230
trigger4 = movecontact
trigger5 = stateno = 200
trigger5 = movecontact

;---------------------------------------------------------------------------
;Crouch_Z
[State -1, Crouch_Z]
type = ChangeState
value = 420
triggerall = !var(59)
triggerall = command = "z"
triggerall = command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl
trigger2 = stateno = 410
trigger2 = movecontact
trigger3 = stateno = 220
trigger3 = movecontact
trigger4 = stateno = 200
trigger4 = movecontact
trigger5 = stateno = 250
trigger5 = movecontact

;---------------------------------------------------------------------------
;Crouch_A
[State -1, Crouch_A]
type = ChangeState
value = 430
triggerall = !var(59)
triggerall = command = "a"
triggerall = command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl
trigger2 = stateno = 400
trigger2 = movecontact
trigger3 = stateno = 200
trigger3 = movecontact
trigger4 = stateno = 230
trigger4 = movecontact

;---------------------------------------------------------------------------
;Crouch_B
[State -1, Crouch_B]
type = ChangeState
value = 440
triggerall = !var(59)
triggerall = command = "b"
triggerall = command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl
trigger2 = stateno = 430
trigger2 = movecontact
trigger3 = stateno = 230
trigger3 = movecontact
trigger4 = stateno = [200,210]
trigger4 = movecontact
trigger5 = stateno = 410 && movecontact

;---------------------------------------------------------------------------
;Crouch_C
[State -1, Crouch_C]
type = ChangeState
value = 450
triggerall = !var(59)
triggerall = command = "c"
triggerall = command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl
trigger2 = stateno = 440
trigger2 = movecontact
trigger3 = stateno = 250
trigger3 = movecontact
trigger4 = stateno = 220
trigger4 = movecontact

;---------------------------------------------------------------------------
;Air_X
[State -1, Air_X]
type = ChangeState
value = 600
triggerall = !var(59)
triggerall = command = "x"
trigger1 = statetype = A
trigger1 = ctrl

;---------------------------------------------------------------------------
;Air_Y
[State -1, Air_Y]
type = ChangeState
value = 610
triggerall = !var(59)
triggerall = command = "y"
triggerall = statetype = A
trigger1 = ctrl
trigger2 = stateno = 600 || stateno = 630
trigger2 = movecontact

;---------------------------------------------------------------------------
;Air_Z
[State -1, Air_Z]
type = ChangeState
value = 620
triggerall = !var(59)
triggerall = command = "z"
triggerall = statetype = A
trigger1 = ctrl
trigger2 = stateno = 610 || stateno = 640
trigger2 = movecontact


;---------------------------------------------------------------------------
;Air_A
[State -1, Air_A]
type = ChangeState
value = 630
triggerall = !var(59)
triggerall = command = "a"
triggerall = statetype = A
trigger1 = ctrl
trigger2 = stateno = 600
trigger2 = movecontact

;---------------------------------------------------------------------------
;Air_B
[State -1, Air_B]
type = ChangeState
value = 640
triggerall = !var(59)
triggerall = command = "b"
triggerall = statetype = A
trigger1 = ctrl
trigger2 = stateno = 630
trigger2 = movecontact
trigger3 = stateno = 600
trigger3 = movecontact
trigger4 = stateno = 610
trigger4 = movecontact

;---------------------------------------------------------------------------
;Air_C
[State -1, Air_C]
type = ChangeState
value = 650
triggerall = !var(59)
triggerall = command = "c"
triggerall = statetype = A
trigger1 = ctrl
trigger2 = (stateno = [600,610]) || stateno = 640 || stateno = 630
trigger2 = movecontact

;---------------------------------------------------------------------------
;Super Jump Up
[State -1, Super Jump Up]
type = ChangeState
value = 60
triggerall = !var(59)
triggerall = command = "super_jump_up" && ctrl
trigger1 = statetype = S && statetype != A 
trigger2 = stateno = 10  
;-----------------------------
;Launcher
[State -1, Launcher] ;by GGN
type = ChangeState
value = 60
triggerall = !var(59)
triggerall = Command = "holdup"
trigger1 = stateno = 240 && movehit

;---------------------------------------------------------------------------
;Taunt
;
[State -1, Taunt]
type = ChangeState
value = 196
triggerall = !var(59)
trigger1 = statetype != A
trigger1 = ctrl
trigger1 = command = "start"

;------------------------------------------------------------------------------
;Recover Rolls
[state -1, recover F]
type = changestate
value = 890
triggerall = !var(59) 
triggerall = RoundState = 2
triggerall = stateno = 5120
TriggerAll = alive 
trigger1 = command = "holdfwd"

[state -1, recover B]
type = changestate
value = 895
triggerall = !var(59) 
triggerall = RoundState = 2
triggerall = stateno = 5120
TriggerAll = alive 
trigger1 = command = "holdback"

;====
;AI
;====
